<?php require_once __DIR__ . '/includes/functions.php'; ?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Patienteninformation | <?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?> - Ihr Aufenthalt</title>
    <meta name="description" content="Informationen für Patienten: Aufnahme, Entlassung, Besuchszeiten, Patientenrechte und Pflege im Krankenhaus.">
    <?php
    $faviconUrl = getSetting('logo_favicon', '');
    if ($faviconUrl):
    ?>
        <link rel="icon" type="image/png" href="<?php echo e($faviconUrl); ?>">
    <?php endif; ?>
    <meta name="keywords" content="Patienteninformation, Krankenhausaufenthalt, Besuchszeiten, Patientenrechte, Aufnahme, Entlassung, Frankfurt">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="https://arsmedicafrankfurt.de/patienteninfo.php">
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "MedicalWebPage",
        "name": "Patienteninformation - Ars Medical Frankfurt",
        "description": "Informationen für Patienten und Angehörige",
        "url": "https://arsmedicafrankfurt.de/patienteninfo.php",
        "breadcrumb": {
            "@type": "BreadcrumbList",
            "itemListElement": [{
                "@type": "ListItem",
                "position": 1,
                "name": "Startseite",
                "item": "https://arsmedicafrankfurt.de/index.php"
            },{
                "@type": "ListItem",
                "position": 2,
                "name": "Patienteninformation"
            }]
        }
    }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #004B7C; --primary-dark: #003a61; --secondary: #00A896;
            --accent: #E8F4F8; --white: #FFFFFF; --gray-50: #F8FAFC;
            --gray-100: #F1F5F9; --gray-200: #E2E8F0; --gray-300: #CBD5E1;
            --gray-400: #94A3B8; --gray-500: #64748B; --gray-600: #475569;
            --gray-700: #334155; --gray-800: #1E293B; --gray-900: #0F172A;
            --danger: #DC2626; --shadow: 0 1px 3px 0 rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1);
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Inter', sans-serif; color: var(--gray-800); background: var(--white); line-height: 1.6; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: var(--white); box-shadow: var(--shadow); }
        .header-top { background: var(--primary); color: var(--white); padding: 0.5rem 0; font-size: 0.875rem; }
        .header-top-content { max-width: 1400px; margin: 0 auto; padding: 0 1.5rem; display: flex; justify-content: space-between; align-items: center; }
        .emergency-hotline { background: var(--danger); padding: 0.25rem 0.75rem; border-radius: 4px; font-weight: 600; }
        .header-main { max-width: 1400px; margin: 0 auto; padding: 1rem 1.5rem; display: flex; justify-content: space-between; align-items: center; }
        .logo { display: flex; align-items: center; gap: 1rem; text-decoration: none; }
        .logo-icon { width: 50px; height: 50px; background: var(--primary); border-radius: 12px; display: flex; align-items: center; justify-content: center; }
        .logo-icon svg { width: 30px; height: 30px; color: var(--white); }
        .logo-text h1 { font-size: 1.5rem; font-weight: 700; color: var(--primary); }
        .nav-desktop { display: flex; gap: 2rem; }
        .nav-desktop a { text-decoration: none; color: var(--gray-700); font-weight: 500; }
        .nav-desktop a.active { color: var(--primary); }
        .btn { padding: 0.75rem 1.5rem; background: var(--primary); color: var(--white); border-radius: 8px; text-decoration: none; font-weight: 600; }
        .page-header { background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%); color: var(--white); padding: 10rem 0 4rem; text-align: center; }
        .page-header h1 { font-size: 3rem; font-weight: 700; margin-bottom: 1rem; }
        .breadcrumb { max-width: 1400px; margin: 0 auto; padding: 1.5rem; color: var(--gray-500); }
        .breadcrumb a { color: var(--primary); text-decoration: none; }
        .section { padding: 5rem 0; }
        .section-header { text-align: center; max-width: 700px; margin: 0 auto 4rem; }
        .section-title { font-size: 2.5rem; font-weight: 700; color: var(--gray-900); margin-bottom: 1rem; }
        .info-grid { max-width: 1400px; margin: 0 auto; padding: 0 1.5rem; display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 2rem; }
        .info-card { background: var(--white); border-radius: 16px; padding: 2rem; box-shadow: var(--shadow); border: 1px solid var(--gray-200); }
        .info-card h3 { font-size: 1.25rem; font-weight: 600; color: var(--gray-900); margin-bottom: 1rem; display: flex; align-items: center; gap: 0.75rem; }
        .info-card h3 svg { width: 24px; height: 24px; color: var(--primary); }
        .info-card ul { list-style: none; }
        .info-card li { padding: 0.75rem 0; border-bottom: 1px solid var(--gray-100); }
        .info-card li:last-child { border-bottom: none; }
        .info-card li strong { display: block; color: var(--gray-900); }
        .info-card li span { color: var(--gray-500); font-size: 0.9375rem; }
        .highlight-box { background: var(--accent); border-left: 4px solid var(--primary); padding: 1.5rem; border-radius: 8px; margin: 1.5rem 0; }
        .footer { background: var(--gray-900); color: var(--white); padding: 4rem 0 0; }
        .footer-content { max-width: 1400px; margin: 0 auto; padding: 0 1.5rem; display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 3rem; }
        .footer-column a { color: var(--gray-400); text-decoration: none; }
        .footer-bottom { border-top: 1px solid var(--gray-800); margin-top: 3rem; padding: 2rem 1.5rem; max-width: 1400px; margin-left: auto; margin-right: auto; display: flex; justify-content: space-between; }
        @media (max-width: 768px) {
            .page-header h1 { font-size: 2rem; }
            .section-title { font-size: 1.875rem; }
            .info-grid { grid-template-columns: 1fr; }
            .footer-content { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-top">
            <div class="header-top-content">
                <span>Windthorststraße 21, 65929 Frankfurt</span>
                <div class="emergency-hotline">NOTFALL: 112</div>
            </div>
        </div>
        <div class="header-main">
            <?php
            $logoUrl = getSetting('logo_url', '');
            if ($logoUrl):
            ?>
                <a href="index.php" class="logo" style="display: flex; align-items: center;">
                    <img src="<?php echo e($logoUrl); ?>" alt="<?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?>" style="max-height: 50px; max-width: 200px; width: auto;">
                </a>
            <?php else: ?>
                <a href="index.php" class="logo">
                    <div class="logo-icon">
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                    </div>
                    <div class="logo-text"><h1>Ars Medical</h1></div>
                </a>
            <?php endif; ?>
            <nav class="nav-desktop">
                <a href="index.php">Startseite</a>
                <a href="services.php">Leistungen</a>
                <a href="doctors.php">Ärzte</a>
                <a href="notfall.php">Notfall</a>
                <a href="patienteninfo.php" class="active">Patienteninfo</a>
                <a href="krankenkassen.php">Krankenkassen</a>
            </nav>
            <a href="index.php#contact" class="btn">Termin buchen</a>
        </div>
    </header>

    <section class="page-header">
        <h1>Patienteninformation</h1>
        <p>Alles Wichtige für Ihren Aufenthalt in unserem Krankenhaus</p>
    </section>

    <nav class="breadcrumb">
        <a href="index.php">Startseite</a> / <span>Patienteninformation</span>
    </nav>

    <section class="section">
        <div class="section-header">
            <h2 class="section-title">Ihr Aufenthalt bei uns</h2>
            <p>Wir möchten Ihren Aufenthalt so angenehm wie möglich gestalten. Hier finden Sie alle wichtigen Informationen.</p>
        </div>

        <div class="info-grid">
            <div class="info-card">
                <h3>
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg>
                    Aufnahme
                </h3>
                <ul>
                    <li><strong>Terminvereinbarung</strong><span>Bitte erscheinen Sie pünktlich zu Ihrem vereinbarten Termin</span></li>
                    <li><strong>Mitbringen</strong><span>Versichertenkarte, Überweisungsschein, aktuelle Medikamente</span></li>
                    <li><strong>Aufnahmezeit</strong><span>Mo-Fr: 7:00-18:00 Uhr, Notfälle: rund um die Uhr</span></li>
                </ul>
            </div>

            <div class="info-card">
                <h3>
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                    Besuchszeiten
                </h3>
                <ul>
                    <li><strong>Allgemeine Stationen</strong><span>Täglich: 14:00-19:00 Uhr</span></li>
                    <li><strong>Intensivstation</strong><span>Nach Absprache mit der Pflege</span></li>
                    <li><strong>Geburtshilfe</strong><span>24 Stunden für Partner/Angehörige</span></li>
                    <li><strong>Bitte beachten</strong><span>Max. 2 Besucher pro Patient zur gleichen Zeit</span></li>
                </ul>
            </div>

            <div class="info-card">
                <h3>
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/></svg>
                    Entlassung
                </h3>
                <ul>
                    <li><strong>Entlassungszeit</strong><span>In der Regel vormittags nach Visite</span></li>
                    <li><strong>Arbeitsunfähigkeit</strong><span>Bescheinigung erhalten Sie vor Entlassung</span></li>
                    <li><strong>Terminvereinbarung</strong><span>Nachsorgetermine werden vor Entlassung vereinbart</span></li>
                </ul>
            </div>

            <div class="info-card">
                <h3>
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/></svg>
                    Patientenrechte
                </h3>
                <ul>
                    <li><strong>Informationsrecht</strong><span>Umfassende Aufklärung über Diagnose und Behandlung</span></li>
                    <li><strong>Einwilligung</strong><span>Freie Entscheidung über Behandlungsmaßnahmen</span></li>
                    <li><strong>Datenschutz</strong><span>Vertraulicher Umgang mit Ihren Daten</span></li>
                    <li><strong>Beschwerderecht</strong><span>Ansprechpartner für Anliegen und Beschwerden</span></li>
                </ul>
            </div>
        </div>

        <div class="highlight-box" style="max-width: 1400px; margin: 3rem auto 0; padding: 0 1.5rem;">
            <h4 style="color: var(--primary); margin-bottom: 0.5rem;">Haben Sie Fragen?</h4>
            <p>Unsere Patientenfassung steht Ihnen montags bis freitags von 8:00 bis 17:00 Uhr zur Verfügung.<br>
            Telefon: <a href="tel:+496912345678" style="color: var(--primary); font-weight: 600;">+49 69 1234 5678</a> | E-Mail: <a href="mailto:patienten@arsmedicafrankfurt.de" style="color: var(--primary);">patienten@arsmedicafrankfurt.de</a></p>
        </div>
    </section>

    <footer class="footer">
        <div class="footer-content">
            <div class="footer-column">
                <h4>Ars Medical Frankfurt</h4>
                <p style="color: var(--gray-400);">Ihr Krankenhaus mit 168 Jahren Tradition.</p>
            </div>
            <div class="footer-column">
                <h4>Informationen</h4>
                <ul style="list-style: none;">
                    <li><a href="notfall.php">Notfall</a></li>
                    <li><a href="patienteninfo.php">Patienteninfo</a></li>
                    <li><a href="krankenkassen.php">Krankenkassen</a></li>
                </ul>
            </div>
            <div class="footer-column">
                <h4>Rechtliches</h4>
                <ul style="list-style: none;">
                    <li><a href="impressum.php">Impressum</a></li>
                    <li><a href="datenschutz.php">Datenschutz</a></li>
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            <p style="color: var(--gray-500);">&copy; 2026 Ars Medical Frankfurt</p>
        </div>
    </footer>
</body>
</html>