<?php require_once __DIR__ . '/includes/functions.php'; ?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notfall & Rettungsstelle | <?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?> - 24/7 Notfallversorgung</title>
    <meta name="description" content="Rund um die Uhr Notfallversorgung in Frankfurt. Unsere Rettungsstelle ist 24 Stunden besetzt. Bei medizinischen Notfällen: 112. Adresse: Windthorststraße 21, 65929 Frankfurt.">
    <?php
    $faviconUrl = getSetting('logo_favicon', '');
    if ($faviconUrl):
    ?>
        <link rel="icon" type="image/png" href="<?php echo e($faviconUrl); ?>">
    <?php endif; ?>
    <meta name="keywords" content="Notfall Frankfurt, Rettungsstelle, Notarzt, 112, medizinischer Notfall, Notfallversorgung, Krankenhaus Notaufnahme">
    <meta name="robots" content="index, follow">
    <meta name="author" content="Ars Medical Frankfurt">
    
    <!-- Open Graph / Social Media -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://arsmedicafrankfurt.de/notfall.php">
    <meta property="og:title" content="Notfall & Rettungsstelle | Ars Medical Frankfurt">
    <meta property="og:description" content="24/7 Notfallversorgung in Frankfurt. Bei medizinischen Notfällen wählen Sie 112.">
    <meta property="og:image" content="https://arsmedicafrankfurt.de/assets/images/emergency-og.jpg">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Notfall & Rettungsstelle | Ars Medical Frankfurt">
    <meta name="twitter:description" content="24/7 Notfallversorgung in Frankfurt. Bei medizinischen Notfällen wählen Sie 112.">
    
    <!-- Canonical URL -->
    <link rel="canonical" href="https://arsmedicafrankfurt.de/notfall.php">
    
    <!-- Structured Data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "EmergencyService",
        "name": "Ars Medical Frankfurt - Notfall & Rettungsstelle",
        "description": "Rund um die Uhr Notfallversorgung in Frankfurt am Main",
        "url": "https://arsmedicafrankfurt.de/notfall.php",
        "telephone": "+49-69-12345678",
        "emergency": "112",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "Windthorststraße 21",
            "addressLocality": "Frankfurt am Main",
            "postalCode": "65929",
            "addressCountry": "DE"
        },
        "geo": {
            "@type": "GeoCoordinates",
            "latitude": "50.1109",
            "longitude": "8.6821"
        },
        "openingHours": "Mo-So 00:00-23:59",
        "isAccessibleForFree": false,
        "paymentAccepted": "Cash, Credit Card, Health Insurance",
        "currenciesAccepted": "EUR"
    }
    </script>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #004B7C;
            --primary-dark: #003a61;
            --secondary: #00A896;
            --accent: #E8F4F8;
            --white: #FFFFFF;
            --gray-50: #F8FAFC;
            --gray-100: #F1F5F9;
            --gray-200: #E2E8F0;
            --gray-300: #CBD5E1;
            --gray-400: #94A3B8;
            --gray-500: #64748B;
            --gray-600: #475569;
            --gray-700: #334155;
            --gray-800: #1E293B;
            --gray-900: #0F172A;
            --danger: #DC2626;
            --warning: #F59E0B;
            --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
            --shadow: 0 1px 3px 0 rgb(0 0 0 / 0.1), 0 1px 2px -1px rgb(0 0 0 / 0.1);
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
            --shadow-xl: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }
        html { scroll-behavior: smooth; }
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            line-height: 1.6;
            color: var(--gray-800);
            background-color: var(--white);
        }

        /* Header */
        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            background: var(--white);
            box-shadow: var(--shadow);
        }

        .header-top {
            background: var(--primary);
            color: var(--white);
            padding: 0.5rem 0;
            font-size: 0.875rem;
        }

        .header-top-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header-top-info {
            display: flex;
            gap: 2rem;
            align-items: center;
        }

        .header-top-info span {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .header-top-info svg { width: 16px; height: 16px; }

        .emergency-hotline {
            background: var(--danger);
            padding: 0.25rem 0.75rem;
            border-radius: 4px;
            font-weight: 600;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.8; }
        }

        .header-main {
            max-width: 1400px;
            margin: 0 auto;
            padding: 1rem 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 1rem;
            text-decoration: none;
            color: var(--primary);
        }

        .logo-icon {
            width: 50px;
            height: 50px;
            background: var(--primary);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .logo-icon svg { width: 30px; height: 30px; color: var(--white); }

        .logo-text h1 {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--primary);
            line-height: 1.2;
        }

        .logo-text span {
            font-size: 0.75rem;
            color: var(--gray-500);
            text-transform: uppercase;
            letter-spacing: 0.1em;
        }

        .nav-desktop {
            display: flex;
            align-items: center;
            gap: 2.5rem;
        }

        .nav-desktop a {
            text-decoration: none;
            color: var(--gray-700);
            font-weight: 500;
            font-size: 0.9375rem;
            transition: color 0.2s;
            position: relative;
        }

        .nav-desktop a:hover,
        .nav-desktop a.active { color: var(--primary); }

        .nav-desktop a::after {
            content: '';
            position: absolute;
            bottom: -4px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--primary);
            transition: width 0.2s;
        }

        .nav-desktop a:hover::after,
        .nav-desktop a.active::after { width: 100%; }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 600;
            font-size: 0.9375rem;
            text-decoration: none;
            transition: all 0.2s;
            border: none;
            cursor: pointer;
        }

        .btn-primary {
            background: var(--primary);
            color: var(--white);
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-1px);
            box-shadow: var(--shadow-md);
        }

        .btn-danger {
            background: var(--danger);
            color: var(--white);
        }

        .btn-danger:hover {
            background: #B91C1C;
            transform: translateY(-1px);
        }

        .btn-lg {
            padding: 1rem 2rem;
            font-size: 1.125rem;
        }

        .btn-sm { padding: 0.5rem 1rem; font-size: 0.875rem; }

        .mobile-menu-btn {
            display: none;
            background: none;
            border: none;
            cursor: pointer;
            padding: 0.5rem;
        }

        .mobile-menu-btn svg { width: 24px; height: 24px; color: var(--gray-700); }

        /* Emergency Hero */
        .emergency-hero {
            background: linear-gradient(135deg, var(--danger) 0%, #B91C1C 100%);
            color: var(--white);
            padding: 10rem 0 5rem;
            text-align: center;
        }

        .emergency-hero h1 {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 1rem;
        }

        .emergency-hero p {
            font-size: 1.25rem;
            opacity: 0.9;
            max-width: 600px;
            margin: 0 auto 2rem;
        }

        .emergency-phone-big {
            display: inline-flex;
            align-items: center;
            gap: 1rem;
            background: rgba(255, 255, 255, 0.2);
            padding: 1.5rem 3rem;
            border-radius: 16px;
            backdrop-filter: blur(10px);
            margin-bottom: 1rem;
        }

        .emergency-phone-big svg {
            width: 48px;
            height: 48px;
        }

        .emergency-phone-big a {
            color: var(--white);
            font-size: 3rem;
            font-weight: 700;
            text-decoration: none;
        }

        .emergency-note {
            font-size: 1rem;
            opacity: 0.8;
        }

        /* Breadcrumb */
        .breadcrumb {
            max-width: 1400px;
            margin: 0 auto;
            padding: 1.5rem;
            display: flex;
            gap: 0.5rem;
            align-items: center;
            font-size: 0.875rem;
            color: var(--gray-500);
        }

        .breadcrumb a {
            color: var(--primary);
            text-decoration: none;
        }

        .breadcrumb a:hover { text-decoration: underline; }

        /* Section Styles */
        .section { padding: 5rem 0; }

        .section-header {
            text-align: center;
            max-width: 700px;
            margin: 0 auto 4rem;
        }

        .section-label {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--primary);
            font-weight: 600;
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            margin-bottom: 1rem;
        }

        .section-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--gray-900);
            margin-bottom: 1rem;
            line-height: 1.2;
        }

        .section-subtitle {
            font-size: 1.125rem;
            color: var(--gray-500);
        }

        /* Info Grid */
        .info-grid {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 2rem;
        }

        .info-card {
            background: var(--white);
            border-radius: 16px;
            padding: 2rem;
            box-shadow: var(--shadow);
            border: 1px solid var(--gray-200);
        }

        .info-card h3 {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--gray-900);
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .info-card h3 svg {
            width: 24px;
            height: 24px;
            color: var(--primary);
        }

        .info-card ul {
            list-style: none;
        }

        .info-card li {
            padding: 0.75rem 0;
            border-bottom: 1px solid var(--gray-100);
            display: flex;
            align-items: flex-start;
            gap: 0.75rem;
        }

        .info-card li:last-child {
            border-bottom: none;
        }

        .info-card li svg {
            width: 20px;
            height: 20px;
            color: var(--secondary);
            flex-shrink: 0;
            margin-top: 0.125rem;
        }

        .info-card li strong {
            display: block;
            color: var(--gray-900);
            margin-bottom: 0.25rem;
        }

        .info-card li span {
            color: var(--gray-500);
            font-size: 0.9375rem;
        }

        /* Emergency Types */
        .emergency-types {
            background: var(--gray-50);
        }

        .types-grid {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 1.5rem;
        }

        .type-card {
            background: var(--white);
            border-radius: 12px;
            padding: 1.5rem;
            box-shadow: var(--shadow-sm);
            border-left: 4px solid var(--danger);
        }

        .type-card h4 {
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--gray-900);
            margin-bottom: 0.5rem;
        }

        .type-card p {
            color: var(--gray-500);
            font-size: 0.9375rem;
        }

        /* Location Section */
        .location-section {
            background: var(--white);
        }

        .location-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4rem;
            align-items: center;
        }

        .location-info h3 {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--gray-900);
            margin-bottom: 1.5rem;
        }

        .location-detail {
            display: flex;
            align-items: flex-start;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .location-detail svg {
            width: 24px;
            height: 24px;
            color: var(--primary);
            flex-shrink: 0;
        }

        .location-detail strong {
            display: block;
            color: var(--gray-900);
            margin-bottom: 0.25rem;
        }

        .location-detail span,
        .location-detail a {
            color: var(--gray-500);
            text-decoration: none;
        }

        .location-detail a:hover {
            color: var(--primary);
        }

        .location-map {
            background: var(--gray-200);
            border-radius: 16px;
            height: 400px;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .location-map iframe {
            width: 100%;
            height: 100%;
            border: none;
        }

        /* Footer */
        .footer {
            background: var(--gray-900);
            color: var(--white);
            padding: 4rem 0 0;
        }

        .footer-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 1fr;
            gap: 3rem;
        }

        .footer-brand .logo { margin-bottom: 1.5rem; }
        .footer-brand .logo-text h1 { color: var(--white); }

        .footer-brand p {
            color: var(--gray-400);
            font-size: 0.9375rem;
            margin-bottom: 1.5rem;
            line-height: 1.7;
        }

        .footer-social {
            display: flex;
            gap: 1rem;
        }

        .footer-social a {
            width: 40px;
            height: 40px;
            background: var(--gray-800);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background 0.2s;
        }

        .footer-social a:hover { background: var(--primary); }

        .footer-social svg { width: 20px; height: 20px; color: var(--white); }

        .footer-column h4 {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            color: var(--white);
        }

        .footer-column ul { list-style: none; }
        .footer-column li { margin-bottom: 0.75rem; }

        .footer-column a {
            color: var(--gray-400);
            text-decoration: none;
            font-size: 0.9375rem;
            transition: color 0.2s;
        }

        .footer-column a:hover { color: var(--white); }

        .footer-bottom {
            border-top: 1px solid var(--gray-800);
            margin-top: 3rem;
            padding: 2rem 1.5rem;
            max-width: 1400px;
            margin-left: auto;
            margin-right: auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }

        .footer-bottom p { color: var(--gray-500); font-size: 0.875rem; }

        .footer-bottom-links {
            display: flex;
            gap: 2rem;
        }

        .footer-bottom-links a {
            color: var(--gray-500);
            text-decoration: none;
            font-size: 0.875rem;
            transition: color 0.2s;
        }

        .footer-bottom-links a:hover { color: var(--white); }

        /* Mobile Navigation */
        .mobile-nav {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: var(--white);
            z-index: 999;
            padding: 6rem 1.5rem 2rem;
            flex-direction: column;
            gap: 1rem;
        }

        .mobile-nav.active { display: flex; }

        .mobile-nav a {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--gray-800);
            text-decoration: none;
            padding: 1rem;
            border-bottom: 1px solid var(--gray-200);
        }

        .mobile-nav-close {
            position: absolute;
            top: 1.5rem;
            right: 1.5rem;
            background: none;
            border: none;
            cursor: pointer;
        }

        .mobile-nav-close svg { width: 28px; height: 28px; color: var(--gray-700); }

        /* Responsive */
        @media (max-width: 1024px) {
            .location-content { grid-template-columns: 1fr; }
            .footer-content { grid-template-columns: 1fr 1fr; }
        }

        @media (max-width: 768px) {
            .nav-desktop { display: none; }
            .mobile-menu-btn { display: block; }
            .header-actions .btn-secondary { display: none; }
            
            .emergency-hero { padding: 8rem 0 4rem; }
            .emergency-hero h1 { font-size: 2rem; }
            .emergency-phone-big a { font-size: 2rem; }
            .section-title { font-size: 1.875rem; }
            
            .info-grid { grid-template-columns: 1fr; }
            .footer-content { grid-template-columns: 1fr; }
            .footer-bottom { flex-direction: column; text-align: center; }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header" id="header">
        <div class="header-top">
            <div class="header-top-content">
                <div class="header-top-info">
                    <span>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                        Windthorststraße 21, 65929 Frankfurt
                    </span>
                    <span>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                        +49 69 12345678
                    </span>
                </div>
                <div class="emergency-hotline">NOTFALL: 112</div>
            </div>
        </div>
        <div class="header-main">
            <?php
            $logoUrl = getSetting('logo_url', '');
            if ($logoUrl):
            ?>
                <a href="index.php" class="logo" style="display: flex; align-items: center;">
                    <img src="<?php echo e($logoUrl); ?>" alt="<?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?>" style="max-height: 50px; max-width: 200px; width: auto;">
                </a>
            <?php else: ?>
                <a href="index.php" class="logo">
                    <div class="logo-icon">
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                    </div>
                    <div class="logo-text">
                        <h1>Ars Medical</h1>
                        <span>Frankfurt</span>
                    </div>
                </a>
            <?php endif; ?>
            <nav class="nav-desktop">
                <a href="index.php">Startseite</a>
                <a href="services.php">Leistungen</a>
                <a href="doctors.php">Ärzte</a>
                <a href="notfall.php" class="active">Notfall</a>
                <a href="patienteninfo.php">Patienteninfo</a>
                <a href="krankenkassen.php">Krankenkassen</a>
            </nav>
            <div class="header-actions">
                <a href="index.php#contact" class="btn btn-primary btn-sm">Termin buchen</a>
                <button class="mobile-menu-btn" onclick="toggleMobileNav()">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/></svg>
                </button>
            </div>
        </div>
    </header>

    <!-- Mobile Navigation -->
    <nav class="mobile-nav" id="mobileNav">
        <button class="mobile-nav-close" onclick="toggleMobileNav()">
            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
        </button>
        <a href="index.php" onclick="toggleMobileNav()">Startseite</a>
        <a href="services.php" onclick="toggleMobileNav()">Leistungen</a>
        <a href="doctors.php" onclick="toggleMobileNav()">Ärzte</a>
        <a href="notfall.php" onclick="toggleMobileNav()">Notfall</a>
        <a href="patienteninfo.php" onclick="toggleMobileNav()">Patienteninfo</a>
        <a href="krankenkassen.php" onclick="toggleMobileNav()">Krankenkassen</a>
    </nav>

    <!-- Emergency Hero -->
    <section class="emergency-hero">
        <h1>Notfall & Rettungsstelle</h1>
        <p>Rund um die Uhr für Sie da - 24 Stunden am Tag, 7 Tage die Woche</p>
        <div class="emergency-phone-big">
            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
            <a href="tel:112">112</a>
        </div>
        <p class="emergency-note">Bei lebensbedrohlichen Notfällen wählen Sie bitte den Notruf 112</p>
    </section>

    <!-- Breadcrumb -->
    <nav class="breadcrumb">
        <a href="index.php">Startseite</a>
        <span>/</span>
        <span>Notfall</span>
    </nav>

    <!-- Emergency Info Section -->
    <section class="section">
        <div class="section-header">
            <span class="section-label">
                <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/></svg>
                Notfallversorgung
            </span>
            <h2 class="section-title">Wichtige Informationen im Notfall</h2>
            <p class="section-subtitle">Unsere Rettungsstelle ist rund um die Uhr besetzt. Hier finden Sie alle wichtigen Informationen für Notfallsituationen.</p>
        </div>

        <div class="info-grid">
            <div class="info-card">
                <h3>
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                    Öffnungszeiten
                </h3>
                <ul>
                    <li>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                        <div>
                            <strong>Rettungsstelle</strong>
                            <span>24 Stunden / 7 Tage die Woche</span>
                        </div>
                    </li>
                    <li>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                        <div>
                            <strong>Herzkatheter-Labor</strong>
                            <span>24 Stunden Notfalldienst</span>
                        </div>
                    </li>
                    <li>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                        <div>
                            <strong>Stroke Unit</strong>
                            <span>Rund um die Uhr besetzt</span>
                        </div>
                    </li>
                </ul>
            </div>

            <div class="info-card">
                <h3>
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                    Kontakt
                </h3>
                <ul>
                    <li>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                        <div>
                            <strong>Notruf (Lebensgefahr)</strong>
                            <span><a href="tel:112" style="color: var(--danger); font-weight: 600;">112</a></span>
                        </div>
                    </li>
                    <li>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                        <div>
                            <strong>Rettungsstelle</strong>
                            <span><a href="tel:+496912345678">+49 69 1234 5678</a></span>
                        </div>
                    </li>
                    <li>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                        <div>
                            <strong>Notfall-Aufnahme</strong>
                            <span>Direkteingang über Parkplatz A</span>
                        </div>
                    </li>
                </ul>
            </div>

            <div class="info-card">
                <h3>
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/></svg>
                    Mitbringen
                </h3>
                <ul>
                    <li>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                        <div>
                            <strong>Versichertenkarte</strong>
                            <span>Gesundheitskarte oder Nachweis</span>
                        </div>
                    </li>
                    <li>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                        <div>
                            <strong>Aktuelle Medikamente</strong>
                            <span>Liste oder Medikamente selbst</span>
                        </div>
                    </li>
                    <li>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                        <div>
                            <strong>Befunde</strong>
                            <span>Wichtige Vorbefunde (falls vorhanden)</span>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </section>

    <!-- Emergency Types -->
    <section class="section emergency-types">
        <div class="section-header">
            <span class="section-label">
                <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/></svg>
                Notfall-Situationen
            </span>
            <h2 class="section-title">Wann sollten Sie die Rettungsstelle aufsuchen?</h2>
            <p class="section-subtitle">Bei folgenden Symptomen ist eine sofortige ärztliche Versorgung notwendig.</p>
        </div>

        <div class="types-grid">
            <div class="type-card">
                <h4>Herzinfarkt</h4>
                <p>Starke Brustschmerzen, Engegefühl, Schmerzen im Arm oder Kiefer, Atemnot, Schwitzen</p>
            </div>
            <div class="type-card">
                <h4>Schlaganfall</h4>
                <p>Plötzliche Gesichtslähmung, Armschwäche, Sprachstörungen, Sehstörungen</p>
            </div>
            <div class="type-card">
                <h4>Schwere Verletzungen</h4>
                <p>Offene Brüche, starke Blutungen, Schädelverletzungen, Bewusstlosigkeit</p>
            </div>
            <div class="type-card">
                <h4>Atemnot</h4>
                <p>Schwere Atembeschwerden, Erstickungsgefahr, bläuliche Lippen</p>
            </div>
            <div class="type-card">
                <h4>Schwere allergische Reaktion</h4>
                <p>Atemnot, Schwellungen, Hautausschlag, Kreislaufprobleme nach Allergenkontakt</p>
            </div>
            <div class="type-card">
                <h4>Starke Schmerzen</h4>
                <p>Unerträgliche Schmerzen, die nicht mit Medikamenten linderbar sind</p>
            </div>
        </div>
    </section>

    <!-- Location Section -->
    <section class="section location-section">
        <div class="section-header">
            <span class="section-label">
                <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                Anfahrt
            </span>
            <h2 class="section-title">So finden Sie uns</h2>
            <p class="section-subtitle">Die Rettungsstelle ist rund um die Uhr erreichbar. Bitte nutzen Sie den separaten Notfalleingang.</p>
        </div>

        <div class="location-content">
            <div class="location-info">
                <h3>Ars Medical Frankfurt - Rettungsstelle</h3>
                
                <div class="location-detail">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                    <div>
                        <strong>Adresse</strong>
                        <span>Windthorststraße 21<br>65929 Frankfurt am Main<br>Notfalleingang: Parkplatz A</span>
                    </div>
                </div>

                <div class="location-detail">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                    <div>
                        <strong>Telefon</strong>
                        <a href="tel:+496912345678">+49 69 1234 5678</a>
                    </div>
                </div>

                <div class="location-detail">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                    <div>
                        <strong>Erreichbarkeit</strong>
                        <span>24 Stunden / 7 Tage die Woche</span>
                    </div>
                </div>

                <div class="location-detail">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                    <div>
                        <strong>Parken</strong>
                        <span>Kostenfreie Parkplätze direkt am Notfalleingang (Parkplatz A)</span>
                    </div>
                </div>
            </div>

            <div class="location-map">
                <iframe 
                    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2558.5!2d8.64!3d50.12!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zNTDCsDA3JzEyLjAiTiA4wrAzOCcyNC4wIkU!5e0!3m2!1sde!2sde!4v1609459200000!5m2!1sde!2sde" 
                    allowfullscreen="" 
                    loading="lazy"
                    title="Ars Medical Frankfurt Standort">
                </iframe>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-content">
            <div class="footer-brand">
                <?php
                $footerImageUrl = getSetting('footer_image_url', '');
                if ($footerImageUrl):
                ?>
                    <a href="index.php" style="display: block; margin-bottom: 1.5rem;">
                        <img src="<?php echo e($footerImageUrl); ?>" alt="<?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?>" style="max-height: 60px; max-width: 250px; width: auto;">
                    </a>
                <?php else: ?>
                    <a href="index.php" class="logo">
                        <div class="logo-icon">
                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                        </div>
                        <div class="logo-text">
                            <h1>Ars Medical</h1>
                            <span>Frankfurt</span>
                        </div>
                    </a>
                <?php endif; ?>
                <p>Ihr Krankenhaus mit 168 Jahren Tradition und modernster Medizin in Frankfurt am Main. Wir stehen für exzellente Patientenversorgung.</p>
                <div class="footer-social">
                    <a href="#" aria-label="Facebook"><svg fill="currentColor" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg></a>
                    <a href="#" aria-label="Twitter"><svg fill="currentColor" viewBox="0 0 24 24"><path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/></svg></a>
                    <a href="#" aria-label="LinkedIn"><svg fill="currentColor" viewBox="0 0 24 24"><path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/></svg></a>
                </div>
            </div>
            <div class="footer-column">
                <h4>Leistungen</h4>
                <ul>
                    <li><a href="services.php">Kardiologie</a></li>
                    <li><a href="services.php">Orthopädie</a></li>
                    <li><a href="services.php">Gynäkologie</a></li>
                    <li><a href="services.php">Radiologie</a></li>
                    <li><a href="services.php">Onkologie</a></li>
                </ul>
            </div>
            <div class="footer-column">
                <h4>Informationen</h4>
                <ul>
                    <li><a href="index.php">Über uns</a></li>
                    <li><a href="doctors.php">Ärzte</a></li>
                    <li><a href="index.php#history">Geschichte</a></li>
                    <li><a href="notfall.php">Notfall</a></li>
                    <li><a href="patienteninfo.php">Patienteninfo</a></li>
                </ul>
            </div>
            <div class="footer-column">
                <h4>Rechtliches</h4>
                <ul>
                    <li><a href="impressum.php">Impressum</a></li>
                    <li><a href="datenschutz.php">Datenschutz</a></li>
                    <li><a href="krankenkassen.php">Krankenkassen</a></li>
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; 2026 Ars Medical Frankfurt. Alle Rechte vorbehalten.</p>
            <div class="footer-bottom-links">
                <a href="impressum.php">Impressum</a>
                <a href="datenschutz.php">Datenschutz</a>
            </div>
        </div>
    </footer>

    <script>
        function toggleMobileNav() {
            const mobileNav = document.getElementById('mobileNav');
            mobileNav.classList.toggle('active');
            document.body.style.overflow = mobileNav.classList.contains('active') ? 'hidden' : '';
        }
    </script>
</body>
</html>