<?php require_once __DIR__ . '/includes/functions.php'; ?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Krankenkassen & Versicherungspartner | <?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?></title>
    <meta name="description" content="<?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?> kooperiert mit allen gesetzlichen und privaten Krankenkassen. AOK, TK, DAK, Barmer und weitere Versicherungspartner.">
    <?php
    $faviconUrl = getSetting('logo_favicon', '');
    if ($faviconUrl):
    ?>
        <link rel="icon" type="image/png" href="<?php echo e($faviconUrl); ?>">
    <?php endif; ?>
    <meta name="keywords" content="Krankenkassen, Krankenversicherung, AOK, TK, DAK, Barmer, KKH, private Krankenversicherung, Frankfurt">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="https://arsmedicafrankfurt.de/krankenkassen.php">
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "MedicalOrganization",
        "name": "Ars Medical Frankfurt",
        "description": "Krankenhaus mit Kooperationen zu allen gesetzlichen und privaten Krankenkassen",
        "url": "https://arsmedicafrankfurt.de/krankenkassen.php",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "Windthorststraße 21",
            "addressLocality": "Frankfurt am Main",
            "postalCode": "65929",
            "addressCountry": "DE"
        }
    }
    </script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #004B7C; --primary-dark: #003a61; --secondary: #00A896;
            --accent: #E8F4F8; --white: #FFFFFF; --gray-50: #F8FAFC;
            --gray-100: #F1F5F9; --gray-200: #E2E8F0; --gray-300: #CBD5E1;
            --gray-400: #94A3B8; --gray-500: #64748B; --gray-600: #475569;
            --gray-700: #334155; --gray-800: #1E293B; --gray-900: #0F172A;
            --danger: #DC2626; --shadow: 0 1px 3px 0 rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1);
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Inter', sans-serif; color: var(--gray-800); background: var(--white); line-height: 1.6; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: var(--white); box-shadow: var(--shadow); }
        .header-top { background: var(--primary); color: var(--white); padding: 0.5rem 0; font-size: 0.875rem; }
        .header-top-content { max-width: 1400px; margin: 0 auto; padding: 0 1.5rem; display: flex; justify-content: space-between; align-items: center; }
        .emergency-hotline { background: var(--danger); padding: 0.25rem 0.75rem; border-radius: 4px; font-weight: 600; }
        .header-main { max-width: 1400px; margin: 0 auto; padding: 1rem 1.5rem; display: flex; justify-content: space-between; align-items: center; }
        .logo { display: flex; align-items: center; gap: 1rem; text-decoration: none; }
        .logo-icon { width: 50px; height: 50px; background: var(--primary); border-radius: 12px; display: flex; align-items: center; justify-content: center; }
        .logo-icon svg { width: 30px; height: 30px; color: var(--white); }
        .logo-text h1 { font-size: 1.5rem; font-weight: 700; color: var(--primary); }
        .nav-desktop { display: flex; gap: 2rem; }
        .nav-desktop a { text-decoration: none; color: var(--gray-700); font-weight: 500; }
        .nav-desktop a.active { color: var(--primary); }
        .btn { padding: 0.75rem 1.5rem; background: var(--primary); color: var(--white); border-radius: 8px; text-decoration: none; font-weight: 600; }
        .page-header { background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%); color: var(--white); padding: 10rem 0 4rem; text-align: center; }
        .page-header h1 { font-size: 3rem; font-weight: 700; margin-bottom: 1rem; }
        .breadcrumb { max-width: 1400px; margin: 0 auto; padding: 1.5rem; color: var(--gray-500); }
        .breadcrumb a { color: var(--primary); text-decoration: none; }
        .section { padding: 5rem 0; }
        .section-header { text-align: center; max-width: 700px; margin: 0 auto 4rem; }
        .section-title { font-size: 2.5rem; font-weight: 700; color: var(--gray-900); margin-bottom: 1rem; }
        .insurance-grid { max-width: 1400px; margin: 0 auto; padding: 0 1.5rem; display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 1.5rem; }
        .insurance-card { background: var(--white); border-radius: 12px; padding: 1.5rem; box-shadow: var(--shadow); border: 1px solid var(--gray-200); text-align: center; transition: transform 0.2s; }
        .insurance-card:hover { transform: translateY(-4px); box-shadow: var(--shadow-lg); }
        .insurance-logo { width: 80px; height: 80px; background: var(--accent); border-radius: 50%; margin: 0 auto 1rem; display: flex; align-items: center; justify-content: center; font-weight: 700; color: var(--primary); font-size: 1.5rem; }
        .insurance-card h3 { font-size: 1.125rem; font-weight: 600; color: var(--gray-900); margin-bottom: 0.5rem; }
        .insurance-card p { color: var(--gray-500); font-size: 0.875rem; }
        .info-box { max-width: 1400px; margin: 3rem auto 0; padding: 0 1.5rem; }
        .info-content { background: var(--accent); border-radius: 16px; padding: 2rem; }
        .info-content h3 { color: var(--primary); margin-bottom: 1rem; }
        .info-content ul { margin-left: 1.5rem; }
        .info-content li { margin-bottom: 0.5rem; color: var(--gray-700); }
        .footer { background: var(--gray-900); color: var(--white); padding: 4rem 0 0; }
        .footer-content { max-width: 1400px; margin: 0 auto; padding: 0 1.5rem; display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 3rem; }
        .footer-column a { color: var(--gray-400); text-decoration: none; }
        .footer-bottom { border-top: 1px solid var(--gray-800); margin-top: 3rem; padding: 2rem 1.5rem; max-width: 1400px; margin-left: auto; margin-right: auto; display: flex; justify-content: space-between; }
        @media (max-width: 768px) {
            .page-header h1 { font-size: 2rem; }
            .section-title { font-size: 1.875rem; }
            .footer-content { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-top">
            <div class="header-top-content">
                <span>Windthorststraße 21, 65929 Frankfurt</span>
                <div class="emergency-hotline">NOTFALL: 112</div>
            </div>
        </div>
        <div class="header-main">
            <?php
            $logoUrl = getSetting('logo_url', '');
            if ($logoUrl):
            ?>
                <a href="index.php" class="logo" style="display: flex; align-items: center;">
                    <img src="<?php echo e($logoUrl); ?>" alt="<?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?>" style="max-height: 50px; max-width: 200px; width: auto;">
                </a>
            <?php else: ?>
                <a href="index.php" class="logo">
                    <div class="logo-icon">
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                    </div>
                    <div class="logo-text"><h1>Ars Medical</h1></div>
                </a>
            <?php endif; ?>
            <nav class="nav-desktop">
                <a href="index.php">Startseite</a>
                <a href="services.php">Leistungen</a>
                <a href="doctors.php">Ärzte</a>
                <a href="notfall.php">Notfall</a>
                <a href="patienteninfo.php">Patienteninfo</a>
                <a href="krankenkassen.php" class="active">Krankenkassen</a>
            </nav>
            <a href="index.php#contact" class="btn">Termin buchen</a>
        </div>
    </header>

    <section class="page-header">
        <h1>Krankenkassen & Versicherungspartner</h1>
        <p>Wir kooperieren mit allen gesetzlichen und privaten Krankenkassen</p>
    </section>

    <nav class="breadcrumb">
        <a href="index.php">Startseite</a> / <span>Krankenkassen</span>
    </nav>

    <section class="section">
        <div class="section-header">
            <h2 class="section-title">Unsere Partner</h2>
            <p>Ars Medical Frankfurt arbeitet mit allen gängigen Krankenkassen zusammen. Egal ob gesetzlich oder privat versichert - Sie sind bei uns in guten Händen.</p>
        </div>

        <div class="insurance-grid">
            <div class="insurance-card">
                <div class="insurance-logo">AOK</div>
                <h3>AOK</h3>
                <p>Allgemeine Ortskrankenkassen</p>
            </div>
            <div class="insurance-card">
                <div class="insurance-logo">TK</div>
                <h3>Techniker Krankenkasse</h3>
                <p>Deutschlands beste Krankenkasse</p>
            </div>
            <div class="insurance-card">
                <div class="insurance-logo">DAK</div>
                <h3>DAK-Gesundheit</h3>
                <p>Für Gesundheit aktiv</p>
            </div>
            <div class="insurance-card">
                <div class="insurance-logo">BARMER</div>
                <h3>Barmer</h3>
                <p>Eine der größten Krankenkassen</p>
            </div>
            <div class="insurance-card">
                <div class="insurance-logo">KKH</div>
                <h3>KKH</h3>
                <p>Kaufmännische Krankenkasse</p>
            </div>
            <div class="insurance-card">
                <div class="insurance-logo">HKK</div>
                <h3>HKK</h3>
                <p>Handelskrankenkasse</p>
            </div>
            <div class="insurance-card">
                <div class="insurance-logo">IKK</div>
                <h3>IKK classic</h3>
                <p>Die Innovationskasse</p>
            </div>
            <div class="insurance-card">
                <div class="insurance-logo">PV</div>
                <h3>Private Versicherungen</h3>
                <p>Alle privaten Krankenversicherungen</p>
            </div>
        </div>

        <div class="info-box">
            <div class="info-content">
                <h3>Wichtige Informationen zur Abrechnung</h3>
                <ul>
                    <li>Bei gesetzlicher Versicherung: Bitte bringen Sie Ihre Gesundheitskarte mit</li>
                    <li>Bei privater Versicherung: Rechnungserstellung erfolgt direkt an Sie</li>
                    <li>Beihilfeberechtigte: Bitte Beihilfemerkblatt vorlegen</li>
                    <li>Selbstzahler: Terminvereinbarung nach Absprache</li>
                </ul>
                <p style="margin-top: 1rem;"><strong>Fragen zur Abrechnung?</strong> Kontaktieren Sie uns: <a href="tel:+496912345678" style="color: var(--primary);">+49 69 1234 5678</a></p>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="footer-content">
            <div class="footer-column">
                <h4>Ars Medical Frankfurt</h4>
                <p style="color: var(--gray-400);">Ihr Krankenhaus mit 168 Jahren Tradition.</p>
            </div>
            <div class="footer-column">
                <h4>Informationen</h4>
                <ul style="list-style: none;">
                    <li><a href="notfall.php">Notfall</a></li>
                    <li><a href="patienteninfo.php">Patienteninfo</a></li>
                    <li><a href="krankenkassen.php">Krankenkassen</a></li>
                </ul>
            </div>
            <div class="footer-column">
                <h4>Rechtliches</h4>
                <ul style="list-style: none;">
                    <li><a href="impressum.php">Impressum</a></li>
                    <li><a href="datenschutz.php">Datenschutz</a></li>
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            <p style="color: var(--gray-500);">&copy; 2026 Ars Medical Frankfurt</p>
        </div>
    </footer>
</body>
</html>