<?php require_once __DIR__ . '/includes/functions.php'; ?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(getSetting('meta_title', 'Ars Medical Frankfurt | Krankenhaus seit 1858')); ?></title>
    <meta name="description" content="<?php echo e(getSetting('meta_description', 'Ars Medical Frankfurt - Ihr Krankenhaus mit 168 Jahren medizinischer Exzellenz in Frankfurt am Main. Moderne Medizin, erfahrene Ärzte, herzliche Pflege.')); ?>">
    <?php
    $faviconUrl = getSetting('logo_favicon', '');
    if ($faviconUrl):
    ?>
        <link rel="icon" type="image/png" href="<?php echo e($faviconUrl); ?>">
    <?php endif; ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #004B7C;
            --primary-dark: #003a61;
            --primary-light: #0066a8;
            --secondary: #00A896;
            --accent: #E8F4F8;
            --white: #FFFFFF;
            --gray-50: #F8FAFC;
            --gray-100: #F1F5F9;
            --gray-200: #E2E8F0;
            --gray-300: #CBD5E1;
            --gray-400: #94A3B8;
            --gray-500: #64748B;
            --gray-600: #475569;
            --gray-700: #334155;
            --gray-800: #1E293B;
            --gray-900: #0F172A;
            --danger: #DC2626;
            --warning: #F59E0B;
            --success: #10B981;
            --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
            --shadow: 0 1px 3px 0 rgb(0 0 0 / 0.1), 0 1px 2px -1px rgb(0 0 0 / 0.1);
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
            --shadow-xl: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html {
            scroll-behavior: smooth;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            line-height: 1.6;
            color: var(--gray-800);
            background-color: var(--white);
        }

        /* Header & Navigation */
        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            background: var(--white);
            box-shadow: var(--shadow);
            transition: all 0.3s ease;
        }

        .header.scrolled {
            box-shadow: var(--shadow-md);
        }

        .header-top {
            background: var(--primary);
            color: var(--white);
            padding: 0.5rem 0;
            font-size: 0.875rem;
        }

        .header-top-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header-top-info {
            display: flex;
            gap: 2rem;
            align-items: center;
        }

        .header-top-info span {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .header-top-info svg {
            width: 16px;
            height: 16px;
        }

        .emergency-hotline {
            background: var(--danger);
            padding: 0.25rem 0.75rem;
            border-radius: 4px;
            font-weight: 600;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.8; }
        }

        .header-main {
            max-width: 1400px;
            margin: 0 auto;
            padding: 1rem 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 1rem;
            text-decoration: none;
            color: var(--primary);
        }

        .logo-icon {
            width: 50px;
            height: 50px;
            background: var(--primary);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .logo-icon svg {
            width: 30px;
            height: 30px;
            color: var(--white);
        }

        .logo-text h1 {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--primary);
            line-height: 1.2;
        }

        .logo-text span {
            font-size: 0.75rem;
            color: var(--gray-500);
            text-transform: uppercase;
            letter-spacing: 0.1em;
        }

        .nav-desktop {
            display: flex;
            align-items: center;
            gap: 2.5rem;
        }

        .nav-desktop a {
            text-decoration: none;
            color: var(--gray-700);
            font-weight: 500;
            font-size: 0.9375rem;
            transition: color 0.2s;
            position: relative;
        }

        .nav-desktop a:hover,
        .nav-desktop a.active {
            color: var(--primary);
        }

        .nav-desktop a::after {
            content: '';
            position: absolute;
            bottom: -4px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--primary);
            transition: width 0.2s;
        }

        .nav-desktop a:hover::after,
        .nav-desktop a.active::after {
            width: 100%;
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 600;
            font-size: 0.9375rem;
            text-decoration: none;
            transition: all 0.2s;
            border: none;
            cursor: pointer;
        }

        .btn-primary {
            background: var(--primary);
            color: var(--white);
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-1px);
            box-shadow: var(--shadow-md);
        }

        .btn-secondary {
            background: var(--white);
            color: var(--primary);
            border: 2px solid var(--primary);
        }

        .btn-secondary:hover {
            background: var(--primary);
            color: var(--white);
        }

        .btn-ghost {
            background: transparent;
            color: var(--gray-600);
            padding: 0.5rem;
        }

        .btn-ghost:hover {
            color: var(--primary);
            background: var(--gray-100);
        }

        .btn-sm {
            padding: 0.5rem 1rem;
            font-size: 0.875rem;
        }

        .language-toggle {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.875rem;
            color: var(--gray-600);
        }

        .language-toggle button {
            background: none;
            border: none;
            cursor: pointer;
            padding: 0.25rem 0.5rem;
            font-weight: 500;
            color: var(--gray-400);
            transition: color 0.2s;
        }

        .language-toggle button.active {
            color: var(--primary);
        }

        .mobile-menu-btn {
            display: none;
            background: none;
            border: none;
            cursor: pointer;
            padding: 0.5rem;
        }

        .mobile-menu-btn svg {
            width: 24px;
            height: 24px;
            color: var(--gray-700);
        }

        /* Hero Section */
        .hero {
            position: relative;
            min-height: 100vh;
            display: flex;
            align-items: center;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            overflow: hidden;
            margin-top: -1px;
            padding-top: 120px;
        }

        .hero-bg {
            position: absolute;
            inset: 0;
            opacity: 0.15;
            background-image: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.4'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
        }

        .hero-content {
            position: relative;
            z-index: 1;
            max-width: 1400px;
            margin: 0 auto;
            padding: 4rem 1.5rem;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4rem;
            align-items: center;
        }

        .hero-text h2 {
            font-size: 3.5rem;
            font-weight: 700;
            color: var(--white);
            line-height: 1.1;
            margin-bottom: 1.5rem;
        }

        .hero-text h2 span {
            color: var(--secondary);
        }

        .hero-text p {
            font-size: 1.25rem;
            color: rgba(255, 255, 255, 0.9);
            margin-bottom: 2rem;
            max-width: 500px;
        }

        .hero-stats {
            display: flex;
            gap: 3rem;
            margin-bottom: 2.5rem;
        }

        .stat-item {
            text-align: center;
        }

        .stat-number {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--white);
            display: block;
        }

        .stat-label {
            font-size: 0.875rem;
            color: rgba(255, 255, 255, 0.7);
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .hero-buttons {
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
        }

        .btn-white {
            background: var(--white);
            color: var(--primary);
        }

        .btn-white:hover {
            background: var(--gray-100);
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
        }

        .btn-outline-white {
            background: transparent;
            color: var(--white);
            border: 2px solid rgba(255, 255, 255, 0.5);
        }

        .btn-outline-white:hover {
            background: var(--white);
            color: var(--primary);
            border-color: var(--white);
        }

        .hero-image {
            position: relative;
        }

        .hero-image-main {
            border-radius: 20px;
            overflow: hidden;
            box-shadow: var(--shadow-xl);
            position: relative;
        }

        .hero-image-main img {
            width: 100%;
            height: 500px;
            object-fit: cover;
            display: block;
        }

        .hero-image-badge {
            position: absolute;
            bottom: -20px;
            left: -20px;
            background: var(--white);
            padding: 1.5rem;
            border-radius: 16px;
            box-shadow: var(--shadow-lg);
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .badge-icon {
            width: 50px;
            height: 50px;
            background: var(--secondary);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .badge-icon svg {
            width: 28px;
            height: 28px;
            color: var(--white);
        }

        .badge-text strong {
            display: block;
            color: var(--gray-900);
            font-size: 1.125rem;
        }

        .badge-text span {
            color: var(--gray-500);
            font-size: 0.875rem;
        }

        /* Section Styles */
        .section {
            padding: 6rem 0;
        }

        .section-header {
            text-align: center;
            max-width: 700px;
            margin: 0 auto 4rem;
        }

        .section-label {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--primary);
            font-weight: 600;
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            margin-bottom: 1rem;
        }

        .section-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--gray-900);
            margin-bottom: 1rem;
            line-height: 1.2;
        }

        .section-subtitle {
            font-size: 1.125rem;
            color: var(--gray-500);
        }

        /* Services Section */
        .services {
            background: var(--gray-50);
        }

        .services-grid {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
        }

        .service-card {
            background: var(--white);
            border-radius: 16px;
            padding: 2rem;
            transition: all 0.3s ease;
            border: 1px solid var(--gray-200);
        }

        .service-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-xl);
            border-color: transparent;
        }

        .service-icon {
            width: 60px;
            height: 60px;
            background: var(--accent);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1.5rem;
        }

        .service-icon svg {
            width: 30px;
            height: 30px;
            color: var(--primary);
        }

        .service-card h3 {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--gray-900);
            margin-bottom: 0.75rem;
        }

        .service-card p {
            color: var(--gray-500);
            font-size: 0.9375rem;
            margin-bottom: 1.5rem;
        }

        .service-link {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--primary);
            font-weight: 600;
            font-size: 0.9375rem;
            text-decoration: none;
            transition: gap 0.2s;
        }

        .service-link:hover {
            gap: 0.75rem;
        }

        /* History Section */
        .history {
            background: var(--white);
        }

        .history-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
        }

        .timeline {
            position: relative;
            padding: 2rem 0;
        }

        .timeline::before {
            content: '';
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            width: 4px;
            height: 100%;
            background: linear-gradient(to bottom, var(--primary), var(--secondary));
            border-radius: 2px;
        }

        .timeline-item {
            display: flex;
            justify-content: flex-end;
            padding-right: 50%;
            position: relative;
            margin-bottom: 4rem;
        }

        .timeline-item:nth-child(even) {
            justify-content: flex-start;
            padding-right: 0;
            padding-left: 50%;
        }

        .timeline-item:last-child {
            margin-bottom: 0;
        }

        .timeline-content {
            max-width: 450px;
            padding: 0 3rem;
            position: relative;
        }

        .timeline-year {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 80px;
            background: var(--primary);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--white);
            font-weight: 700;
            font-size: 1rem;
            box-shadow: var(--shadow-lg);
            z-index: 1;
        }

        .timeline-item:nth-child(even) .timeline-year {
            background: var(--secondary);
        }

        .timeline-card {
            background: var(--white);
            border-radius: 16px;
            padding: 2rem;
            box-shadow: var(--shadow-lg);
            border: 1px solid var(--gray-200);
        }

        .timeline-card h3 {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--gray-900);
            margin-bottom: 0.75rem;
        }

        .timeline-card p {
            color: var(--gray-500);
            font-size: 0.9375rem;
        }

        .timeline-highlight {
            display: inline-block;
            background: var(--accent);
            color: var(--primary);
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            margin-bottom: 1rem;
        }

        /* Stats Section */
        .stats {
            background: var(--primary);
            color: var(--white);
            padding: 4rem 0;
        }

        .stats-grid {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 2rem;
            text-align: center;
        }

        .stat-box {
            padding: 1.5rem;
        }

        .stat-box .number {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .stat-box .label {
            font-size: 1rem;
            opacity: 0.9;
        }

        /* Doctors Preview */
        .doctors-preview {
            background: var(--gray-50);
        }

        .doctors-grid {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 2rem;
        }

        .doctor-card {
            background: var(--white);
            border-radius: 16px;
            overflow: hidden;
            box-shadow: var(--shadow);
            transition: all 0.3s ease;
        }

        .doctor-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-xl);
        }

        .doctor-image {
            height: 280px;
            background: var(--gray-200);
            position: relative;
            overflow: hidden;
        }

        .doctor-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .doctor-info {
            padding: 1.5rem;
        }

        .doctor-info h4 {
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--gray-900);
            margin-bottom: 0.25rem;
        }

        .doctor-info .specialty {
            color: var(--primary);
            font-size: 0.875rem;
            font-weight: 500;
            margin-bottom: 0.75rem;
        }

        .doctor-info p {
            color: var(--gray-500);
            font-size: 0.875rem;
        }

        /* Emergency Section */
        .emergency {
            background: linear-gradient(135deg, var(--danger) 0%, #B91C1C 100%);
            color: var(--white);
            padding: 4rem 0;
        }

        .emergency-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 2rem;
        }

        .emergency-text h3 {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .emergency-text p {
            opacity: 0.9;
            font-size: 1.125rem;
        }

        .emergency-phone {
            display: flex;
            align-items: center;
            gap: 1rem;
            background: rgba(255, 255, 255, 0.15);
            padding: 1rem 2rem;
            border-radius: 12px;
            backdrop-filter: blur(10px);
        }

        .emergency-phone svg {
            width: 32px;
            height: 32px;
        }

        .emergency-phone a {
            color: var(--white);
            font-size: 1.75rem;
            font-weight: 700;
            text-decoration: none;
        }

        /* Contact Section */
        .contact {
            background: var(--white);
        }

        .contact-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4rem;
        }

        .contact-info h3 {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--gray-900);
            margin-bottom: 1.5rem;
        }

        .contact-details {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }

        .contact-item {
            display: flex;
            align-items: flex-start;
            gap: 1rem;
        }

        .contact-item-icon {
            width: 48px;
            height: 48px;
            background: var(--accent);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .contact-item-icon svg {
            width: 24px;
            height: 24px;
            color: var(--primary);
        }

        .contact-item-text strong {
            display: block;
            color: var(--gray-900);
            margin-bottom: 0.25rem;
        }

        .contact-item-text span,
        .contact-item-text a {
            color: var(--gray-500);
            text-decoration: none;
        }

        .contact-item-text a:hover {
            color: var(--primary);
        }

        .contact-form {
            background: var(--gray-50);
            padding: 2.5rem;
            border-radius: 16px;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-group label {
            display: block;
            font-weight: 500;
            color: var(--gray-700);
            margin-bottom: 0.5rem;
        }

        .form-group input,
        .form-group textarea,
        .form-group select {
            width: 100%;
            padding: 0.875rem 1rem;
            border: 1px solid var(--gray-300);
            border-radius: 8px;
            font-size: 1rem;
            font-family: inherit;
            transition: border-color 0.2s, box-shadow 0.2s;
            background: var(--white);
        }

        .form-group input:focus,
        .form-group textarea:focus,
        .form-group select:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(0, 75, 124, 0.1);
        }

        .form-group textarea {
            resize: vertical;
            min-height: 120px;
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
        }

        /* Footer */
        .footer {
            background: var(--gray-900);
            color: var(--white);
            padding: 4rem 0 0;
        }

        .footer-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 1fr;
            gap: 3rem;
        }

        .footer-brand .logo {
            margin-bottom: 1.5rem;
        }

        .footer-brand .logo-text h1 {
            color: var(--white);
        }

        .footer-brand p {
            color: var(--gray-400);
            font-size: 0.9375rem;
            margin-bottom: 1.5rem;
            line-height: 1.7;
        }

        .footer-social {
            display: flex;
            gap: 1rem;
        }

        .footer-social a {
            width: 40px;
            height: 40px;
            background: var(--gray-800);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background 0.2s;
        }

        .footer-social a:hover {
            background: var(--primary);
        }

        .footer-social svg {
            width: 20px;
            height: 20px;
            color: var(--white);
        }

        .footer-column h4 {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            color: var(--white);
        }

        .footer-column ul {
            list-style: none;
        }

        .footer-column li {
            margin-bottom: 0.75rem;
        }

        .footer-column a {
            color: var(--gray-400);
            text-decoration: none;
            font-size: 0.9375rem;
            transition: color 0.2s;
        }

        .footer-column a:hover {
            color: var(--white);
        }

        .footer-bottom {
            border-top: 1px solid var(--gray-800);
            margin-top: 3rem;
            padding: 2rem 1.5rem;
            max-width: 1400px;
            margin-left: auto;
            margin-right: auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }

        .footer-bottom p {
            color: var(--gray-500);
            font-size: 0.875rem;
        }

        .footer-bottom-links {
            display: flex;
            gap: 2rem;
        }

        .footer-bottom-links a {
            color: var(--gray-500);
            text-decoration: none;
            font-size: 0.875rem;
            transition: color 0.2s;
        }

        .footer-bottom-links a:hover {
            color: var(--white);
        }

        /* Mobile Navigation */
        .mobile-nav {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: var(--white);
            z-index: 999;
            padding: 6rem 1.5rem 2rem;
            flex-direction: column;
            gap: 1rem;
        }

        .mobile-nav.active {
            display: flex;
        }

        .mobile-nav a {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--gray-800);
            text-decoration: none;
            padding: 1rem;
            border-bottom: 1px solid var(--gray-200);
        }

        .mobile-nav-close {
            position: absolute;
            top: 1.5rem;
            right: 1.5rem;
            background: none;
            border: none;
            cursor: pointer;
        }

        .mobile-nav-close svg {
            width: 28px;
            height: 28px;
            color: var(--gray-700);
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .hero-content {
                grid-template-columns: 1fr;
                text-align: center;
            }

            .hero-text p {
                margin-left: auto;
                margin-right: auto;
            }

            .hero-stats {
                justify-content: center;
            }

            .hero-buttons {
                justify-content: center;
            }

            .hero-image {
                order: -1;
            }

            .hero-image-main img {
                height: 350px;
            }

            .contact-content {
                grid-template-columns: 1fr;
            }

            .footer-content {
                grid-template-columns: 1fr 1fr;
            }
        }

        @media (max-width: 768px) {
            .nav-desktop {
                display: none;
            }

            .mobile-menu-btn {
                display: block;
            }

            .header-actions .btn-secondary {
                display: none;
            }

            .hero {
                padding-top: 100px;
            }

            .hero-text h2 {
                font-size: 2.25rem;
            }

            .hero-stats {
                flex-direction: column;
                gap: 1.5rem;
            }

            .section-title {
                font-size: 1.875rem;
            }

            .timeline::before {
                left: 20px;
            }

            .timeline-item,
            .timeline-item:nth-child(even) {
                justify-content: flex-start;
                padding-left: 60px;
                padding-right: 0;
            }

            .timeline-year {
                left: 20px;
                transform: translateX(-50%);
                width: 60px;
                height: 60px;
                font-size: 0.75rem;
            }

            .timeline-content {
                padding: 0;
            }

            .emergency-content {
                flex-direction: column;
                text-align: center;
            }

            .footer-content {
                grid-template-columns: 1fr;
            }

            .footer-bottom {
                flex-direction: column;
                text-align: center;
            }

            .form-row {
                grid-template-columns: 1fr;
            }
        }

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-fade-in {
            animation: fadeInUp 0.6s ease forwards;
        }

        /* Utility Classes */
        .text-center { text-align: center; }
        .mt-2 { margin-top: 0.5rem; }
        .mt-4 { margin-top: 1rem; }
        .mt-8 { margin-top: 2rem; }
        .mb-2 { margin-bottom: 0.5rem; }
        .mb-4 { margin-bottom: 1rem; }
        .mb-8 { margin-bottom: 2rem; }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header" id="header">
        <div class="header-top">
            <div class="header-top-content">
                <div class="header-top-info">
                    <span>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                        <?php echo e(getSetting('hospital_address', 'Friedrichstraße 123, 60311 Frankfurt am Main')); ?>
                    </span>
                    <span>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                        <?php echo e(getSetting('hospital_phone', '+49 69 1234 5678')); ?>
                    </span>
                </div>
                <div class="emergency-hotline">
                    NOTFALL: <?php echo e(getSetting('emergency_phone', '112')); ?>
                </div>
            </div>
        </div>
        <div class="header-main">
            <?php
            $logoUrl = getSetting('logo_url', '');
            if ($logoUrl):
            ?>
                <a href="index.php" class="logo" style="display: flex; align-items: center;">
                    <img src="<?php echo e($logoUrl); ?>" alt="<?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?>" style="max-height: 50px; max-width: 200px; width: auto;">
                </a>
            <?php else: ?>
                <a href="index.php" class="logo">
                    <div class="logo-icon">
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                    </div>
                    <div class="logo-text">
                        <h1>Ars Medical</h1>
                        <span>Frankfurt</span>
                    </div>
                </a>
            <?php endif; ?>
            <nav class="nav-desktop">
                <a href="index.php" class="active">Startseite</a>
                <a href="services.php">Leistungen</a>
                <a href="doctors.php">Ärzte</a>
                <a href="notfall.php">Notfall</a>
                <a href="patienteninfo.php">Patienteninfo</a>
                <a href="krankenkassen.php">Krankenkassen</a>
            </nav>
            <div class="header-actions">
                <a href="index.php#contact" class="btn btn-primary btn-sm">Termin buchen</a>
                <button class="mobile-menu-btn" onclick="toggleMobileNav()">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/></svg>
                </button>
            </div>
        </div>
    </header>

    <!-- Mobile Navigation -->
    <nav class="mobile-nav" id="mobileNav">
        <button class="mobile-nav-close" onclick="toggleMobileNav()">
            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
        </button>
        <a href="index.php" onclick="toggleMobileNav()">Startseite</a>
        <a href="services.php" onclick="toggleMobileNav()">Leistungen</a>
        <a href="doctors.php" onclick="toggleMobileNav()">Ärzte</a>
        <a href="notfall.php" onclick="toggleMobileNav()">Notfall</a>
        <a href="patienteninfo.php" onclick="toggleMobileNav()">Patienteninfo</a>
        <a href="krankenkassen.php" onclick="toggleMobileNav()">Krankenkassen</a>
    </nav>

    <!-- Hero Section -->
    <section class="hero" id="home">
        <div class="hero-bg"></div>
        <div class="hero-content">
            <div class="hero-text">
                <h2>168 Jahre <span>medizinische Exzellenz</span></h2>
                <p>Willkommen bei Ars Medical Frankfurt – Ihrem Krankenhaus mit Tradition und modernster Medizin. Seit 1858 stehen wir für herausragende Patientenversorgung in der Metropolregion Frankfurt.</p>
                <div class="hero-stats">
                    <div class="stat-item">
                        <span class="stat-number">168</span>
                        <span class="stat-label">Jahre Erfahrung</span>
                    </div>
                    <div class="stat-item">
                        <span class="stat-number">50+</span>
                        <span class="stat-label">Fachärzte</span>
                    </div>
                    <div class="stat-item">
                        <span class="stat-number">200+</span>
                        <span class="stat-label">Betten</span>
                    </div>
                </div>
                <div class="hero-buttons">
                    <a href="#contact" class="btn btn-white">Termin vereinbaren</a>
                    <a href="#services" class="btn btn-outline-white">Unsere Leistungen</a>
                    <a href="tel:112" class="btn btn-outline-white" style="border-color: var(--danger); color: #FCA5A5;">
                        <svg width="20" height="20" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                        Notfall 112
                    </a>
                </div>
            </div>
            <div class="hero-image">
                <div class="hero-image-main">
                    <img src="https://images.unsplash.com/photo-1587351021759-3e566b6af7cc?w=800&h=600&fit=crop" alt="Ars Medical Frankfurt Krankenhaus">
                </div>
                <div class="hero-image-badge">
                    <div class="badge-icon">
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                    </div>
                    <div class="badge-text">
                        <strong>Zertifiziert</strong>
                        <span>KTQ-Qualitätszertifikat</span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section class="section services" id="services">
        <div class="section-header">
            <span class="section-label">
                <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"/></svg>
                Medizinische Leistungen
            </span>
            <h2 class="section-title">Unsere Fachbereiche</h2>
            <p class="section-subtitle">Moderne Medizin kombiniert mit menschlicher Wärme – entdecken Sie unser breites Spektrum an medizinischen Leistungen.</p>
        </div>
        <div class="services-grid">
            <div class="service-card">
                <div class="service-icon">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/></svg>
                </div>
                <h3>Kardiologie</h3>
                <p>Herz-Kreislauf-Erkrankungen diagnostizieren und behandeln wir mit modernster Technologie und bewährten Therapien.</p>
                <a href="#" class="service-link">Mehr erfahren →</a>
            </div>
            <div class="service-card">
                <div class="service-icon">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"/></svg>
                </div>
                <h3>Orthopädie</h3>
                <p>Von Gelenkersatz bis Sportmedizin – unsere Orthopäden helfen Ihnen zurück zu mehr Beweglichkeit und Lebensqualität.</p>
                <a href="#" class="service-link">Mehr erfahren →</a>
            </div>
            <div class="service-card">
                <div class="service-icon">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/></svg>
                </div>
                <h3>Geburtshilfe</h3>
                <p>Begleitung während der Schwangerschaft, Geburt und Wochenbett mit höchster Sorgfalt und modernster Ausstattung.</p>
                <a href="#" class="service-link">Mehr erfahren →</a>
            </div>
            <div class="service-card">
                <div class="service-icon">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                </div>
                <h3>Radiologie</h3>
                <p>Präzise Diagnostik durch MRT, CT und digitale Röntgentechnik für eine fundierte Behandlungsplanung.</p>
                <a href="#" class="service-link">Mehr erfahren →</a>
            </div>
            <div class="service-card">
                <div class="service-icon">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"/></svg>
                </div>
                <h3>Onkologie</h3>
                <p>Interdisziplinäre Krebstherapie mit Chemotherapie, Bestrahlung und chirurgischen Verfahren.</p>
                <a href="#" class="service-link">Mehr erfahren →</a>
            </div>
            <div class="service-card">
                <div class="service-icon">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/></svg>
                </div>
                <h3>Notfallmedizin</h3>
                <p>Rund um die Uhr besetzte Notaufnahme mit modernstem Equipment für alle medizinischen Notfälle.</p>
                <a href="#" class="service-link">Mehr erfahren →</a>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="stats">
        <div class="stats-grid">
            <div class="stat-box">
                <div class="number">168</div>
                <div class="label">Jahre Erfahrung</div>
            </div>
            <div class="stat-box">
                <div class="number">50+</div>
                <div class="label">Fachärzte</div>
            </div>
            <div class="stat-box">
                <div class="number">200+</div>
                <div class="label">Krankenhausbetten</div>
            </div>
            <div class="stat-box">
                <div class="number">25.000+</div>
                <div class="label">Patienten jährlich</div>
            </div>
        </div>
    </section>

    <!-- History Section -->
    <section class="section history" id="history">
        <div class="section-header">
            <span class="section-label">
                <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                Unsere Geschichte
            </span>
            <h2 class="section-title">168 Jahre medizinische Tradition</h2>
            <p class="section-subtitle">Von einer kleinen Klinik 1858 zu einem modernen Krankenhaus der Maximalversorgung – unsere Geschichte ist geprägt von Innovation und menschlicher Fürsorge.</p>
        </div>
        <div class="history-content">
            <div class="timeline">
                <div class="timeline-item">
                    <div class="timeline-year">1858</div>
                    <div class="timeline-content">
                        <div class="timeline-card">
                            <span class="timeline-highlight">Gründung</span>
                            <h3>Die Anfänge</h3>
                            <p>Dr. Heinrich Müller gründet die „Frankfurter Heilanstalt" mit 12 Betten in einem ehemaligen Wohnhaus in der Innenstadt. Der Fokus liegt auf der Versorgung der wachsenden Industriearbeiterschaft.</p>
                        </div>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-year">1920</div>
                    <div class="timeline-content">
                        <div class="timeline-card">
                            <span class="timeline-highlight">Expansion</span>
                            <h3>Neubau & Wachstum</h3>
                            <p>Umzug an den heutigen Standort in Frankfurt-Höchst. Das neue Krankenhaus verfügt über 150 Betten und moderne OP-Säle. Erste Röntgenanlage wird installiert.</p>
                        </div>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-year">1975</div>
                    <div class="timeline-content">
                        <div class="timeline-card">
                            <span class="timeline-highlight">Modernisierung</span>
                            <h3>Zeit der Innovation</h3>
                            <p>Erweiterung auf 200 Betten. Einführung der ersten Intensivstation und des CT-Scanners. Ausbildungsstätte für Pflegefachkräfte wird eingerichtet.</p>
                        </div>
                    </div>
                </div>
                <div class="timeline-item">
                    <div class="timeline-year">2026</div>
                    <div class="timeline-content">
                        <div class="timeline-card">
                            <span class="timeline-highlight">Heute</span>
                            <h3>Zukunft der Medizin</h3>
                            <p>Modernstes Krankenhaus mit 200+ Betten, 50 Fachärzten, roboterassistierter Chirurgie und digitalem Patientenmanagement. Weiterhin familiär geführt mit dem Anspruch auf höchste Qualität.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Doctors Preview -->
    <section class="section doctors-preview" id="doctors">
        <div class="section-header">
            <span class="section-label">
                <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg>
                Unser Ärzteteam
            </span>
            <h2 class="section-title">Erfahrene Spezialisten</h2>
            <p class="section-subtitle">Unser Team aus über 50 Fachärzten steht Ihnen mit modernster Medizin und menschlicher Wärme zur Seite.</p>
        </div>
        <div class="doctors-grid">
            <div class="doctor-card">
                <div class="doctor-image">
                    <img src="https://images.unsplash.com/photo-1612349317150-e413f6a5b16d?w=400&h=500&fit=crop" alt="Dr. Klaus Schmidt">
                </div>
                <div class="doctor-info">
                    <h4>Dr. Klaus Schmidt</h4>
                    <div class="specialty">Chefarzt Kardiologie</div>
                    <p>Über 25 Jahre Erfahrung in der interventionellen Kardiologie und Herzrhythmusstörungen.</p>
                </div>
            </div>
            <div class="doctor-card">
                <div class="doctor-image">
                    <img src="https://images.unsplash.com/photo-1559839734-2b71ea197ec2?w=400&h=500&fit=crop" alt="Dr. Maria Weber">
                </div>
                <div class="doctor-info">
                    <h4>Dr. Maria Weber</h4>
                    <div class="specialty">Leitende Ärztin Gynäkologie</div>
                    <p>Spezialisiert auf minimally-invasive Chirurgie und Geburtshilfe mit hohem Risiko.</p>
                </div>
            </div>
            <div class="doctor-card">
                <div class="doctor-image">
                    <img src="https://images.unsplash.com/photo-1622253692010-333f2da6031d?w=400&h=500&fit=crop" alt="Dr. Thomas Müller">
                </div>
                <div class="doctor-info">
                    <h4>Dr. Thomas Müller</h4>
                    <div class="specialty">Oberarzt Orthopädie</div>
                    <p>Experte für Gelenkersatz-Operationen und Sportorthopädie mit internationaler Erfahrung.</p>
                </div>
            </div>
            <div class="doctor-card">
                <div class="doctor-image">
                    <img src="https://images.unsplash.com/photo-1594824476967-48c8b964273f?w=400&h=500&fit=crop" alt="Dr. Sarah Hoffmann">
                </div>
                <div class="doctor-info">
                    <h4>Dr. Sarah Hoffmann</h4>
                    <div class="specialty">Fachärztin für Onkologie</div>
                    <p>Führend in der personalisierten Krebstherapie und klinischen Forschung.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Emergency Section -->
    <section class="emergency">
        <div class="emergency-content">
            <div class="emergency-text">
                <h3>Medizinischer Notfall?</h3>
                <p>Unsere Notaufnahme ist rund um die Uhr besetzt. Bei lebensbedrohlichen Notfällen wählen Sie 112.</p>
            </div>
            <div class="emergency-phone">
                <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                <a href="tel:<?php echo preg_replace('/[^\d+]/', '', getSetting('ambulance_phone', '+496912345679')); ?>"><?php echo e(getSetting('ambulance_phone', '+49 69 1234 5679')); ?></a>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="section contact" id="contact">
        <div class="section-header">
            <span class="section-label">
                <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                Kontakt
            </span>
            <h2 class="section-title">Kontaktieren Sie uns</h2>
            <p class="section-subtitle">Haben Sie Fragen oder möchten einen Termin vereinbaren? Wir sind für Sie da.</p>
        </div>
        <div class="contact-content">
            <div class="contact-info">
                <h3>So erreichen Sie uns</h3>
                <div class="contact-details">
                    <div class="contact-item">
                        <div class="contact-item-icon">
                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                        </div>
                        <div class="contact-item-text">
                            <strong>Adresse</strong>
                            <span><?php echo nl2br(e(getSetting('hospital_address', "Friedrichstraße 123\n60311 Frankfurt am Main\nDeutschland"))); ?></span>
                        </div>
                    </div>
                    <div class="contact-item">
                        <div class="contact-item-icon">
                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                        </div>
                        <div class="contact-item-text">
                            <strong>Telefon</strong>
                            <a href="tel:<?php echo preg_replace('/[^\d+]/', '', getSetting('hospital_phone', '+496912345678')); ?>"><?php echo e(getSetting('hospital_phone', '+49 69 1234 5678')); ?></a>
                        </div>
                    </div>
                    <div class="contact-item">
                        <div class="contact-item-icon">
                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                        </div>
                        <div class="contact-item-text">
                            <strong>E-Mail</strong>
                            <a href="mailto:<?php echo e(getSetting('hospital_email', 'info@arsmedicafrankfurt.de')); ?>"><?php echo e(getSetting('hospital_email', 'info@arsmedicafrankfurt.de')); ?></a>
                        </div>
                    </div>
                    <div class="contact-item">
                        <div class="contact-item-icon">
                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                        </div>
                        <div class="contact-item-text">
                            <strong>Öffnungszeiten</strong>
                            <span>Notaufnahme: <?php echo e(getSetting('emergency_hours', '24/7')); ?> geöffnet<br>Terminsprechstunde: <?php echo e(getSetting('opening_hours', 'Mo-Fr 8:00-18:00')); ?></span>
                        </div>
                    </div>
                </div>
            </div>
            <form class="contact-form" onsubmit="handleContactSubmit(event)">
                <h3 style="margin-bottom: 1.5rem; font-size: 1.25rem; font-weight: 600;">Termin anfragen</h3>
                <div class="form-row">
                    <div class="form-group">
                        <label for="firstName">Vorname</label>
                        <input type="text" id="firstName" name="firstName" required>
                    </div>
                    <div class="form-group">
                        <label for="lastName">Nachname</label>
                        <input type="text" id="lastName" name="lastName" required>
                    </div>
                </div>
                <div class="form-group">
                    <label for="email">E-Mail-Adresse</label>
                    <input type="email" id="email" name="email" required>
                </div>
                <div class="form-group">
                    <label for="phone">Telefonnummer</label>
                    <input type="tel" id="phone" name="phone">
                </div>
                <div class="form-group">
                    <label for="department">Fachbereich</label>
                    <select id="department" name="department" required>
                        <option value="">Bitte wählen</option>
                        <option value="kardiologie">Kardiologie</option>
                        <option value="orthopaedie">Orthopädie</option>
                        <option value="gynaekologie">Gynäkologie & Geburtshilfe</option>
                        <option value="radiologie">Radiologie</option>
                        <option value="onkologie">Onkologie</option>
                        <option value="notfall">Notfall</option>
                        <option value="anderes">Anderes</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="message">Ihre Nachricht</label>
                    <textarea id="message" name="message" placeholder="Beschreiben Sie kurz Ihr Anliegen..."></textarea>
                </div>
                <div class="form-group" style="display: flex; align-items: flex-start; gap: 0.75rem;">
                    <input type="checkbox" id="privacy" name="privacy" required style="width: auto; margin-top: 0.25rem;">
                    <label for="privacy" style="margin-bottom: 0; font-weight: 400; font-size: 0.875rem;">Ich stimme der Verarbeitung meiner Daten gemäß der <a href="#" style="color: var(--primary);">Datenschutzerklärung</a> zu.</label>
                </div>
                <button type="submit" class="btn btn-primary" style="width: 100%;">Termin anfragen</button>
            </form>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-content">
            <div class="footer-brand">
                <a href="#" class="logo">
                    <div class="logo-icon">
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                    </div>
                    <div class="logo-text">
                        <h1>Ars Medical</h1>
                        <span>Frankfurt</span>
                    </div>
                </a>
                <p>Ihr Krankenhaus mit 168 Jahren Tradition und modernster Medizin in Frankfurt am Main. Wir stehen für exzellente Patientenversorgung, innovative Behandlungsmethoden und menschliche Wärme.</p>
                <div class="footer-social">
                    <a href="#" aria-label="Facebook">
                        <svg fill="currentColor" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>
                    </a>
                    <a href="#" aria-label="Twitter">
                        <svg fill="currentColor" viewBox="0 0 24 24"><path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/></svg>
                    </a>
                    <a href="#" aria-label="LinkedIn">
                        <svg fill="currentColor" viewBox="0 0 24 24"><path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/></svg>
                    </a>
                    <a href="#" aria-label="Instagram">
                        <svg fill="currentColor" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zM12 0C8.741 0 8.333.014 7.053.072 2.695.272.273 2.69.073 7.052.014 8.333 0 8.741 0 12c0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98C8.333 23.986 8.741 24 12 24c3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98C15.668.014 15.259 0 12 0zm0 5.838a6.162 6.162 0 100 12.324 6.162 6.162 0 000-12.324zM12 16a4 4 0 110-8 4 4 0 010 8zm6.406-11.845a1.44 1.44 0 100 2.881 1.44 1.44 0 000-2.881z"/></svg>
                    </a>
                </div>
            </div>
            <div class="footer-column">
                <h4>Leistungen</h4>
                <ul>
                    <li><a href="services.php">Kardiologie</a></li>
                    <li><a href="services.php">Orthopädie</a></li>
                    <li><a href="services.php">Gynäkologie</a></li>
                    <li><a href="services.php">Radiologie</a></li>
                    <li><a href="services.php">Onkologie</a></li>
                </ul>
            </div>
            <div class="footer-column">
                <h4>Informationen</h4>
                <ul>
                    <li><a href="index.php">Über uns</a></li>
                    <li><a href="doctors.php">Ärzte</a></li>
                    <li><a href="index.php#history">Geschichte</a></li>
                    <li><a href="notfall.php">Notfall</a></li>
                    <li><a href="patienteninfo.php">Patienteninfo</a></li>
                </ul>
            </div>
            <div class="footer-column">
                <h4>Rechtliches</h4>
                <ul>
                    <li><a href="impressum.php">Impressum</a></li>
                    <li><a href="datenschutz.php">Datenschutz</a></li>
                    <li><a href="krankenkassen.php">Krankenkassen</a></li>
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; 2026 Ars Medical Frankfurt. Alle Rechte vorbehalten.</p>
            <div class="footer-bottom-links">
                <a href="impressum.php">Impressum</a>
                <a href="datenschutz.php">Datenschutz</a>
            </div>
        </div>
    </footer>

    <!-- JavaScript -->
    <script>
        // Mobile Navigation Toggle
        function toggleMobileNav() {
            const mobileNav = document.getElementById('mobileNav');
            mobileNav.classList.toggle('active');
            document.body.style.overflow = mobileNav.classList.contains('active') ? 'hidden' : '';
        }

        // Header Scroll Effect
        window.addEventListener('scroll', () => {
            const header = document.getElementById('header');
            if (window.scrollY > 50) {
                header.classList.add('scrolled');
            } else {
                header.classList.remove('scrolled');
            }
        });

        // Smooth Scroll for Navigation Links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    const headerOffset = 100;
                    const elementPosition = target.getBoundingClientRect().top;
                    const offsetPosition = elementPosition + window.pageYOffset - headerOffset;
                    
                    window.scrollTo({
                        top: offsetPosition,
                        behavior: 'smooth'
                    });
                }
            });
        });

        // Active Navigation Link
        const sections = document.querySelectorAll('section[id]');
        const navLinks = document.querySelectorAll('.nav-desktop a');

        window.addEventListener('scroll', () => {
            let current = '';
            sections.forEach(section => {
                const sectionTop = section.offsetTop;
                const sectionHeight = section.clientHeight;
                if (scrollY >= sectionTop - 200) {
                    current = section.getAttribute('id');
                }
            });

            navLinks.forEach(link => {
                link.classList.remove('active');
                if (link.getAttribute('href') === '#' + current) {
                    link.classList.add('active');
                }
            });
        });

        // Contact Form Handler
        function handleContactSubmit(e) {
            e.preventDefault();
            
            const formData = new FormData(e.target);
            const data = Object.fromEntries(formData);
            
            // Show success message
            alert('Vielen Dank für Ihre Anfrage! Wir werden uns in Kürze bei Ihnen melden.');
            e.target.reset();
        }

        // Animate elements on scroll
        const observerOptions = {
            root: null,
            rootMargin: '0px',
            threshold: 0.1
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('animate-fade-in');
                    observer.unobserve(entry.target);
                }
            });
        }, observerOptions);

        document.querySelectorAll('.service-card, .doctor-card, .timeline-item').forEach(el => {
            observer.observe(el);
        });
    </script>
</body>
</html>