<?php require_once __DIR__ . '/includes/functions.php'; ?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ärzte & Spezialisten | <?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?></title>
    <meta name="description" content="Lernen Sie unser Team erfahrener Fachärzte kennen. Spezialisten für Kardiologie, Orthopädie, Gynäkologie, Onkologie und mehr.">
    <?php
    $faviconUrl = getSetting('logo_favicon', '');
    if ($faviconUrl):
    ?>
        <link rel="icon" type="image/png" href="<?php echo e($faviconUrl); ?>">
    <?php endif; ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #004B7C;
            --primary-dark: #003a61;
            --secondary: #00A896;
            --accent: #E8F4F8;
            --white: #FFFFFF;
            --gray-50: #F8FAFC;
            --gray-100: #F1F5F9;
            --gray-200: #E2E8F0;
            --gray-300: #CBD5E1;
            --gray-400: #94A3B8;
            --gray-500: #64748B;
            --gray-600: #475569;
            --gray-700: #334155;
            --gray-800: #1E293B;
            --gray-900: #0F172A;
            --danger: #DC2626;
            --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
            --shadow: 0 1px 3px 0 rgb(0 0 0 / 0.1), 0 1px 2px -1px rgb(0 0 0 / 0.1);
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
            --shadow-xl: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }
        html { scroll-behavior: smooth; }
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            line-height: 1.6;
            color: var(--gray-800);
            background-color: var(--white);
        }

        /* Header */
        .header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            background: var(--white);
            box-shadow: var(--shadow);
        }

        .header-top {
            background: var(--primary);
            color: var(--white);
            padding: 0.5rem 0;
            font-size: 0.875rem;
        }

        .header-top-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header-top-info {
            display: flex;
            gap: 2rem;
            align-items: center;
        }

        .header-top-info span {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .header-top-info svg { width: 16px; height: 16px; }

        .emergency-hotline {
            background: var(--danger);
            padding: 0.25rem 0.75rem;
            border-radius: 4px;
            font-weight: 600;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.8; }
        }

        .header-main {
            max-width: 1400px;
            margin: 0 auto;
            padding: 1rem 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 1rem;
            text-decoration: none;
            color: var(--primary);
        }

        .logo-icon {
            width: 50px;
            height: 50px;
            background: var(--primary);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .logo-icon svg { width: 30px; height: 30px; color: var(--white); }

        .logo-text h1 {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--primary);
            line-height: 1.2;
        }

        .logo-text span {
            font-size: 0.75rem;
            color: var(--gray-500);
            text-transform: uppercase;
            letter-spacing: 0.1em;
        }

        .nav-desktop {
            display: flex;
            align-items: center;
            gap: 2.5rem;
        }

        .nav-desktop a {
            text-decoration: none;
            color: var(--gray-700);
            font-weight: 500;
            font-size: 0.9375rem;
            transition: color 0.2s;
            position: relative;
        }

        .nav-desktop a:hover,
        .nav-desktop a.active { color: var(--primary); }

        .nav-desktop a::after {
            content: '';
            position: absolute;
            bottom: -4px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--primary);
            transition: width 0.2s;
        }

        .nav-desktop a:hover::after,
        .nav-desktop a.active::after { width: 100%; }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 600;
            font-size: 0.9375rem;
            text-decoration: none;
            transition: all 0.2s;
            border: none;
            cursor: pointer;
        }

        .btn-primary {
            background: var(--primary);
            color: var(--white);
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-1px);
            box-shadow: var(--shadow-md);
        }

        .btn-sm { padding: 0.5rem 1rem; font-size: 0.875rem; }

        .mobile-menu-btn {
            display: none;
            background: none;
            border: none;
            cursor: pointer;
            padding: 0.5rem;
        }

        .mobile-menu-btn svg { width: 24px; height: 24px; color: var(--gray-700); }

        /* Page Header */
        .page-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: var(--white);
            padding: 10rem 0 4rem;
            text-align: center;
        }

        .page-header h1 {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 1rem;
        }

        .page-header p {
            font-size: 1.25rem;
            opacity: 0.9;
            max-width: 600px;
            margin: 0 auto;
        }

        /* Breadcrumb */
        .breadcrumb {
            max-width: 1400px;
            margin: 0 auto;
            padding: 1.5rem;
            display: flex;
            gap: 0.5rem;
            align-items: center;
            font-size: 0.875rem;
            color: var(--gray-500);
        }

        .breadcrumb a {
            color: var(--primary);
            text-decoration: none;
        }

        .breadcrumb a:hover { text-decoration: underline; }

        /* Section Styles */
        .section { padding: 5rem 0; }

        .section-header {
            text-align: center;
            max-width: 700px;
            margin: 0 auto 4rem;
        }

        .section-label {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--primary);
            font-weight: 600;
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.1em;
            margin-bottom: 1rem;
        }

        .section-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--gray-900);
            margin-bottom: 1rem;
            line-height: 1.2;
        }

        .section-subtitle {
            font-size: 1.125rem;
            color: var(--gray-500);
        }

        /* Filter Tabs */
        .filter-tabs {
            display: flex;
            justify-content: center;
            gap: 0.5rem;
            flex-wrap: wrap;
            margin-bottom: 3rem;
            padding: 0 1.5rem;
        }

        .filter-tab {
            padding: 0.625rem 1.25rem;
            background: var(--white);
            border: 1px solid var(--gray-300);
            border-radius: 9999px;
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--gray-600);
            cursor: pointer;
            transition: all 0.2s;
        }

        .filter-tab:hover {
            border-color: var(--primary);
            color: var(--primary);
        }

        .filter-tab.active {
            background: var(--primary);
            border-color: var(--primary);
            color: var(--white);
        }

        /* Doctors Grid */
        .doctors-grid {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            gap: 2rem;
        }

        .doctor-card {
            background: var(--white);
            border-radius: 16px;
            overflow: hidden;
            box-shadow: var(--shadow);
            border: 1px solid var(--gray-200);
            transition: all 0.3s ease;
        }

        .doctor-card:hover {
            transform: translateY(-4px);
            box-shadow: var(--shadow-xl);
        }

        .doctor-image {
            height: 320px;
            background: var(--gray-200);
            position: relative;
            overflow: hidden;
        }

        .doctor-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.3s;
        }

        .doctor-card:hover .doctor-image img {
            transform: scale(1.05);
        }

        .doctor-badge {
            position: absolute;
            top: 1rem;
            right: 1rem;
            background: var(--primary);
            color: var(--white);
            padding: 0.375rem 0.875rem;
            border-radius: 9999px;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .doctor-info {
            padding: 1.5rem;
        }

        .doctor-info h3 {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--gray-900);
            margin-bottom: 0.25rem;
        }

        .doctor-specialty {
            color: var(--primary);
            font-weight: 600;
            font-size: 0.9375rem;
            margin-bottom: 0.75rem;
        }

        .doctor-description {
            color: var(--gray-500);
            font-size: 0.9375rem;
            margin-bottom: 1rem;
            line-height: 1.6;
        }

        .doctor-meta {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 1rem;
            font-size: 0.875rem;
            color: var(--gray-500);
        }

        .doctor-meta span {
            display: flex;
            align-items: center;
            gap: 0.375rem;
        }

        .doctor-meta svg {
            width: 16px;
            height: 16px;
            color: var(--gray-400);
        }

        .doctor-actions {
            display: flex;
            gap: 0.75rem;
        }

        .doctor-actions .btn {
            flex: 1;
            justify-content: center;
        }

        /* Stats Section */
        .stats-section {
            background: var(--accent);
            padding: 4rem 0;
        }

        .stats-grid {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 2rem;
            text-align: center;
        }

        .stat-item .number {
            font-size: 3rem;
            font-weight: 700;
            color: var(--primary);
            margin-bottom: 0.5rem;
        }

        .stat-item .label {
            color: var(--gray-600);
            font-size: 1rem;
        }

        /* Footer */
        .footer {
            background: var(--gray-900);
            color: var(--white);
            padding: 4rem 0 0;
        }

        .footer-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: grid;
            grid-template-columns: 2fr 1fr 1fr 1fr;
            gap: 3rem;
        }

        .footer-brand .logo { margin-bottom: 1.5rem; }
        .footer-brand .logo-text h1 { color: var(--white); }

        .footer-brand p {
            color: var(--gray-400);
            font-size: 0.9375rem;
            margin-bottom: 1.5rem;
            line-height: 1.7;
        }

        .footer-social {
            display: flex;
            gap: 1rem;
        }

        .footer-social a {
            width: 40px;
            height: 40px;
            background: var(--gray-800);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background 0.2s;
        }

        .footer-social a:hover { background: var(--primary); }

        .footer-social svg { width: 20px; height: 20px; color: var(--white); }

        .footer-column h4 {
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            color: var(--white);
        }

        .footer-column ul { list-style: none; }
        .footer-column li { margin-bottom: 0.75rem; }

        .footer-column a {
            color: var(--gray-400);
            text-decoration: none;
            font-size: 0.9375rem;
            transition: color 0.2s;
        }

        .footer-column a:hover { color: var(--white); }

        .footer-bottom {
            border-top: 1px solid var(--gray-800);
            margin-top: 3rem;
            padding: 2rem 1.5rem;
            max-width: 1400px;
            margin-left: auto;
            margin-right: auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }

        .footer-bottom p { color: var(--gray-500); font-size: 0.875rem; }

        .footer-bottom-links {
            display: flex;
            gap: 2rem;
        }

        .footer-bottom-links a {
            color: var(--gray-500);
            text-decoration: none;
            font-size: 0.875rem;
            transition: color 0.2s;
        }

        .footer-bottom-links a:hover { color: var(--white); }

        /* Mobile Navigation */
        .mobile-nav {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: var(--white);
            z-index: 999;
            padding: 6rem 1.5rem 2rem;
            flex-direction: column;
            gap: 1rem;
        }

        .mobile-nav.active { display: flex; }

        .mobile-nav a {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--gray-800);
            text-decoration: none;
            padding: 1rem;
            border-bottom: 1px solid var(--gray-200);
        }

        .mobile-nav-close {
            position: absolute;
            top: 1.5rem;
            right: 1.5rem;
            background: none;
            border: none;
            cursor: pointer;
        }

        .mobile-nav-close svg { width: 28px; height: 28px; color: var(--gray-700); }

        /* Responsive */
        @media (max-width: 1024px) {
            .footer-content { grid-template-columns: 1fr 1fr; }
        }

        @media (max-width: 768px) {
            .nav-desktop { display: none; }
            .mobile-menu-btn { display: block; }
            .header-actions .btn-secondary { display: none; }
            
            .page-header { padding: 8rem 0 3rem; }
            .page-header h1 { font-size: 2rem; }
            .section-title { font-size: 1.875rem; }
            
            .doctors-grid { grid-template-columns: 1fr; }
            .footer-content { grid-template-columns: 1fr; }
            .footer-bottom { flex-direction: column; text-align: center; }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="header" id="header">
        <div class="header-top">
            <div class="header-top-content">
                <div class="header-top-info">
                    <span>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                        Windthorststraße 21, 65929 Frankfurt
                    </span>
                    <span>
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                        +49 69 12345678
                    </span>
                </div>
                <div class="emergency-hotline">NOTFALL: 112</div>
            </div>
        </div>
        <div class="header-main">
            <?php
            $logoUrl = getSetting('logo_url', '');
            if ($logoUrl):
            ?>
                <a href="index.php" class="logo" style="display: flex; align-items: center;">
                    <img src="<?php echo e($logoUrl); ?>" alt="<?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?>" style="max-height: 50px; max-width: 200px; width: auto;">
                </a>
            <?php else: ?>
                <a href="index.php" class="logo">
                    <div class="logo-icon">
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                    </div>
                    <div class="logo-text">
                        <h1>Ars Medical</h1>
                        <span>Frankfurt</span>
                    </div>
                </a>
            <?php endif; ?>
            <nav class="nav-desktop">
                <a href="index.php">Startseite</a>
                <a href="services.php">Leistungen</a>
                <a href="doctors.php" class="active">Ärzte</a>
                <a href="notfall.php">Notfall</a>
                <a href="patienteninfo.php">Patienteninfo</a>
                <a href="krankenkassen.php">Krankenkassen</a>
            </nav>
            <div class="header-actions">
                <a href="index.php#contact" class="btn btn-primary btn-sm">Termin buchen</a>
                <button class="mobile-menu-btn" onclick="toggleMobileNav()">
                    <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/></svg>
                </button>
            </div>
        </div>
    </header>

    <!-- Mobile Navigation -->
    <nav class="mobile-nav" id="mobileNav">
        <button class="mobile-nav-close" onclick="toggleMobileNav()">
            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
        </button>
        <a href="index.php" onclick="toggleMobileNav()">Startseite</a>
        <a href="services.php" onclick="toggleMobileNav()">Leistungen</a>
        <a href="doctors.php" onclick="toggleMobileNav()">Ärzte</a>
        <a href="notfall.php" onclick="toggleMobileNav()">Notfall</a>
        <a href="patienteninfo.php" onclick="toggleMobileNav()">Patienteninfo</a>
        <a href="krankenkassen.php" onclick="toggleMobileNav()">Krankenkassen</a>
    </nav>

    <!-- Page Header -->
    <section class="page-header">
        <h1>Unser Ärzteteam</h1>
        <p>Über 50 Fachärzte stehen Ihnen mit modernster Medizin und menschlicher Wärme zur Seite. Lernen Sie unser Team kennen.</p>
    </section>

    <!-- Breadcrumb -->
    <nav class="breadcrumb">
        <a href="index.php">Startseite</a>
        <span>/</span>
        <span>Ärzte</span>
    </nav>

    <!-- Doctors Section -->
    <section class="section">
        <div class="section-header">
            <span class="section-label">
                <svg width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg>
                Fachärzte
            </span>
            <h2 class="section-title">Spezialisten für Ihre Gesundheit</h2>
            <p class="section-subtitle">Unsere erfahrenen Ärzte decken ein breites Spektrum medizinischer Fachrichtungen ab und arbeiten interdisziplinär zusammen.</p>
        </div>

        <!-- Filter Tabs -->
        <div class="filter-tabs">
            <button class="filter-tab active" onclick="filterDoctors('all', this)">Alle Ärzte</button>
            <button class="filter-tab" onclick="filterDoctors('Kardiologie', this)">Kardiologie</button>
            <button class="filter-tab" onclick="filterDoctors('Orthopädie', this)">Orthopädie</button>
            <button class="filter-tab" onclick="filterDoctors('Gynäkologie', this)">Gynäkologie</button>
            <button class="filter-tab" onclick="filterDoctors('Onkologie', this)">Onkologie</button>
            <button class="filter-tab" onclick="filterDoctors('Radiologie', this)">Radiologie</button>
        </div>

        <!-- Doctors Grid -->
        <div class="doctors-grid" id="doctorsGrid">
            <!-- Dr. Klaus Schmidt -->
            <div class="doctor-card" data-specialty="Kardiologie">
                <div class="doctor-image">
                    <img src="https://images.unsplash.com/photo-1612349317150-e413f6a5b16d?w=400&h=500&fit=crop" alt="Dr. Klaus Schmidt">
                    <span class="doctor-badge">Chefarzt</span>
                </div>
                <div class="doctor-info">
                    <h3>Dr. Klaus Schmidt</h3>
                    <div class="doctor-specialty">Chefarzt Kardiologie</div>
                    <p class="doctor-description">Über 25 Jahre Erfahrung in der interventionellen Kardiologie und Behandlung von Herzrhythmusstörungen. Spezialisiert auf minimal-invasive Herzeingriffe.</p>
                    <div class="doctor-meta">
                        <span><svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>25+ Jahre Erfahrung</span>
                        <span><svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>KTQ-zertifiziert</span>
                    </div>
                    <div class="doctor-actions">
                        <a href="index.php#contact" class="btn btn-primary btn-sm">Termin buchen</a>
                        <a href="services.php" class="btn btn-sm" style="background: var(--gray-100); color: var(--gray-700);">Profil</a>
                    </div>
                </div>
            </div>

            <!-- Dr. Maria Weber -->
            <div class="doctor-card" data-specialty="Gynäkologie">
                <div class="doctor-image">
                    <img src="https://images.unsplash.com/photo-1559839734-2b71ea197ec2?w=400&h=500&fit=crop" alt="Dr. Maria Weber">
                    <span class="doctor-badge">Leitend</span>
                </div>
                <div class="doctor-info">
                    <h3>Dr. Maria Weber</h3>
                    <div class="doctor-specialty">Leitende Ärztin Gynäkologie</div>
                    <p class="doctor-description">Spezialisiert auf minimal-invasive Chirurgie und Geburtshilfe mit hohem Risiko. Führend in der laparoskopischen Operationstechnik.</p>
                    <div class="doctor-meta">
                        <span><svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>18 Jahre Erfahrung</span>
                        <span><svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>Perinatalzentrum</span>
                    </div>
                    <div class="doctor-actions">
                        <a href="index.php#contact" class="btn btn-primary btn-sm">Termin buchen</a>
                        <a href="services.php" class="btn btn-sm" style="background: var(--gray-100); color: var(--gray-700);">Profil</a>
                    </div>
                </div>
            </div>

            <!-- Dr. Thomas Müller -->
            <div class="doctor-card" data-specialty="Orthopädie">
                <div class="doctor-image">
                    <img src="https://images.unsplash.com/photo-1622253692010-333f2da6031d?w=400&h=500&fit=crop" alt="Dr. Thomas Müller">
                    <span class="doctor-badge">Oberarzt</span>
                </div>
                <div class="doctor-info">
                    <h3>Dr. Thomas Müller</h3>
                    <div class="doctor-specialty">Oberarzt Orthopädie</div>
                    <p class="doctor-description">Experte für Gelenkersatz-Operationen und Sportorthopädie mit internationaler Erfahrung. Behandelt Profisportler und Freizeitathleten.</p>
                    <div class="doctor-meta">
                        <span><svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>20 Jahre Erfahrung</span>
                        <span><svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>EndoProthetikZentrum</span>
                    </div>
                    <div class="doctor-actions">
                        <a href="index.php#contact" class="btn btn-primary btn-sm">Termin buchen</a>
                        <a href="services.php" class="btn btn-sm" style="background: var(--gray-100); color: var(--gray-700);">Profil</a>
                    </div>
                </div>
            </div>

            <!-- Dr. Sarah Hoffmann -->
            <div class="doctor-card" data-specialty="Onkologie">
                <div class="doctor-image">
                    <img src="https://images.unsplash.com/photo-1594824476967-48c8b964273f?w=400&h=500&fit=crop" alt="Dr. Sarah Hoffmann">
                    <span class="doctor-badge">Fachärztin</span>
                </div>
                <div class="doctor-info">
                    <h3>Dr. Sarah Hoffmann</h3>
                    <div class="doctor-specialty">Fachärztin für Onkologie</div>
                    <p class="doctor-description">Führend in der personalisierten Krebstherapie und klinischen Forschung. Spezialisiert auf Immuntherapie und zielgerichtete Therapien.</p>
                    <div class="doctor-meta">
                        <span><svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>15 Jahre Erfahrung</span>
                        <span><svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>Onkologisches Zentrum</span>
                    </div>
                    <div class="doctor-actions">
                        <a href="index.php#contact" class="btn btn-primary btn-sm">Termin buchen</a>
                        <a href="services.php" class="btn btn-sm" style="background: var(--gray-100); color: var(--gray-700);">Profil</a>
                    </div>
                </div>
            </div>

            <!-- Dr. Michael Braun -->
            <div class="doctor-card" data-specialty="Radiologie">
                <div class="doctor-image">
                    <img src="https://images.unsplash.com/photo-1537368910025-700350fe46c7?w=400&h=500&fit=crop" alt="Dr. Michael Braun">
                    <span class="doctor-badge">Leitend</span>
                </div>
                <div class="doctor-info">
                    <h3>Dr. Michael Braun</h3>
                    <div class="doctor-specialty">Leitender Radiologe</div>
                    <p class="doctor-description">Spezialist für MRT- und CT-Diagnostik mit Fokus auf frühe Krebserkennung und interventionelle Radiologie. Pionier der digitalen Bildgebung.</p>
                    <div class="doctor-meta">
                        <span><svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>22 Jahre Erfahrung</span>
                        <span><svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>3-Tesla MRT</span>
                    </div>
                    <div class="doctor-actions">
                        <a href="index.php#contact" class="btn btn-primary btn-sm">Termin buchen</a>
                        <a href="services.php" class="btn btn-sm" style="background: var(--gray-100); color: var(--gray-700);">Profil</a>
                    </div>
                </div>
            </div>

            <!-- Dr. Anna Fischer -->
            <div class="doctor-card" data-specialty="Kardiologie">
                <div class="doctor-image">
                    <img src="https://images.unsplash.com/photo-1651008376811-b90baee60c1f?w=400&h=500&fit=crop" alt="Dr. Anna Fischer">
                    <span class="doctor-badge">Oberärztin</span>
                </div>
                <div class="doctor-info">
                    <h3>Dr. Anna Fischer</h3>
                    <div class="doctor-specialty">Oberärztin Kardiologie</div>
                    <p class="doctor-description">Spezialisiert auf pädiatrische Kardiologie und angeborene Herzfehler. Leitet das Herzkatheter-Labor und die Rhythmologie-Abteilung.</p>
                    <div class="doctor-meta">
                        <span><svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>16 Jahre Erfahrung</span>
                        <span><svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>Herzkatheter 24/7</span>
                    </div>
                    <div class="doctor-actions">
                        <a href="index.php#contact" class="btn btn-primary btn-sm">Termin buchen</a>
                        <a href="services.php" class="btn btn-sm" style="background: var(--gray-100); color: var(--gray-700);">Profil</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="stats-section">
        <div class="stats-grid">
            <div class="stat-item">
                <div class="number">50+</div>
                <div class="label">Fachärzte</div>
            </div>
            <div class="stat-item">
                <div class="number">12</div>
                <div class="label">Fachbereiche</div>
            </div>
            <div class="stat-item">
                <div class="number">25.000+</div>
                <div class="label">Patienten jährlich</div>
            </div>
            <div class="stat-item">
                <div class="number">168</div>
                <div class="label">Jahre Erfahrung</div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="footer-content">
            <div class="footer-brand">
                <?php
                $footerImageUrl = getSetting('footer_image_url', '');
                if ($footerImageUrl):
                ?>
                    <a href="index.php" style="display: block; margin-bottom: 1.5rem;">
                        <img src="<?php echo e($footerImageUrl); ?>" alt="<?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?>" style="max-height: 60px; max-width: 250px; width: auto;">
                    </a>
                <?php else: ?>
                    <a href="index.php" class="logo">
                        <div class="logo-icon">
                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                        </div>
                        <div class="logo-text">
                            <h1>Ars Medical</h1>
                            <span>Frankfurt</span>
                        </div>
                    </a>
                <?php endif; ?>
                <p>Ihr Krankenhaus mit 168 Jahren Tradition und modernster Medizin in Frankfurt am Main.</p>
                <div class="footer-social">
                    <a href="#" aria-label="Facebook"><svg fill="currentColor" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg></a>
                    <a href="#" aria-label="Twitter"><svg fill="currentColor" viewBox="0 0 24 24"><path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/></svg></a>
                    <a href="#" aria-label="LinkedIn"><svg fill="currentColor" viewBox="0 0 24 24"><path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/></svg></a>
                </div>
            </div>
            <div class="footer-column">
                <h4>Leistungen</h4>
                <ul>
                    <li><a href="services.php">Kardiologie</a></li>
                    <li><a href="services.php">Orthopädie</a></li>
                    <li><a href="services.php">Gynäkologie</a></li>
                    <li><a href="services.php">Radiologie</a></li>
                    <li><a href="services.php">Onkologie</a></li>
                </ul>
            </div>
            <div class="footer-column">
                <h4>Informationen</h4>
                <ul>
                    <li><a href="notfall.php">Notfall</a></li>
                    <li><a href="patienteninfo.php">Patienteninfo</a></li>
                    <li><a href="krankenkassen.php">Krankenkassen</a></li>
                    <li><a href="index.php#contact">Kontakt</a></li>
                </ul>
            </div>
            <div class="footer-column">
                <h4>Rechtliches</h4>
                <ul>
                    <li><a href="impressum.php">Impressum</a></li>
                    <li><a href="datenschutz.php">Datenschutz</a></li>
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; 2026 Ars Medical Frankfurt. Alle Rechte vorbehalten.</p>
            <div class="footer-bottom-links">
                <a href="impressum.php">Impressum</a>
                <a href="datenschutz.php">Datenschutz</a>
            </div>
        </div>
    </footer>

    <script>
        function toggleMobileNav() {
            const mobileNav = document.getElementById('mobileNav');
            mobileNav.classList.toggle('active');
            document.body.style.overflow = mobileNav.classList.contains('active') ? 'hidden' : '';
        }

        function filterDoctors(specialty, btn) {
            // Update active tab
            document.querySelectorAll('.filter-tab').forEach(tab => tab.classList.remove('active'));
            btn.classList.add('active');

            // Filter doctors
            const cards = document.querySelectorAll('.doctor-card');
            cards.forEach(card => {
                if (specialty === 'all' || card.dataset.specialty === specialty) {
                    card.style.display = 'block';
                } else {
                    card.style.display = 'none';
                }
            });
        }
    </script>
</body>
</html>