<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Datenschutzerklärung | Ars Medical Frankfurt - DSGVO</title>
    <meta name="description" content="Datenschutzerklärung gemäß DSGVO. Informationen zur Verarbeitung Ihrer personenbezogenen Daten bei Ars Medical Frankfurt.">
    <meta name="robots" content="index, follow">
    <link rel="canonical" href="https://arsmedicafrankfurt.de/datenschutz.php">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #004B7C; --primary-dark: #003a61; --secondary: #00A896;
            --accent: #E8F4F8; --white: #FFFFFF; --gray-50: #F8FAFC;
            --gray-100: #F1F5F9; --gray-200: #E2E8F0; --gray-300: #CBD5E1;
            --gray-400: #94A3B8; --gray-500: #64748B; --gray-600: #475569;
            --gray-700: #334155; --gray-800: #1E293B; --gray-900: #0F172A;
            --danger: #DC2626; --shadow: 0 1px 3px 0 rgb(0 0 0 / 0.1);
        }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Inter', sans-serif; color: var(--gray-800); background: var(--white); line-height: 1.6; }
        .header { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; background: var(--white); box-shadow: var(--shadow); }
        .header-top { background: var(--primary); color: var(--white); padding: 0.5rem 0; font-size: 0.875rem; }
        .header-top-content { max-width: 1400px; margin: 0 auto; padding: 0 1.5rem; display: flex; justify-content: space-between; align-items: center; }
        .emergency-hotline { background: var(--danger); padding: 0.25rem 0.75rem; border-radius: 4px; font-weight: 600; }
        .header-main { max-width: 1400px; margin: 0 auto; padding: 1rem 1.5rem; display: flex; justify-content: space-between; align-items: center; }
        .logo { display: flex; align-items: center; gap: 1rem; text-decoration: none; }
        .logo-icon { width: 50px; height: 50px; background: var(--primary); border-radius: 12px; display: flex; align-items: center; justify-content: center; }
        .logo-icon svg { width: 30px; height: 30px; color: var(--white); }
        .logo-text h1 { font-size: 1.5rem; font-weight: 700; color: var(--primary); }
        .nav-desktop { display: flex; gap: 2rem; }
        .nav-desktop a { text-decoration: none; color: var(--gray-700); font-weight: 500; }
        .btn { padding: 0.75rem 1.5rem; background: var(--primary); color: var(--white); border-radius: 8px; text-decoration: none; font-weight: 600; }
        .page-header { background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%); color: var(--white); padding: 10rem 0 4rem; text-align: center; }
        .page-header h1 { font-size: 3rem; font-weight: 700; margin-bottom: 1rem; }
        .breadcrumb { max-width: 1400px; margin: 0 auto; padding: 1.5rem; color: var(--gray-500); }
        .breadcrumb a { color: var(--primary); text-decoration: none; }
        .section { padding: 5rem 0; }
        .content { max-width: 900px; margin: 0 auto; padding: 0 1.5rem; }
        .legal-section { margin-bottom: 3rem; }
        .legal-section h2 { font-size: 1.5rem; font-weight: 700; color: var(--gray-900); margin-bottom: 1rem; padding-bottom: 0.5rem; border-bottom: 2px solid var(--primary); }
        .legal-section h3 { font-size: 1.125rem; font-weight: 600; color: var(--gray-800); margin: 1.5rem 0 0.75rem; }
        .legal-section p { color: var(--gray-600); margin-bottom: 1rem; }
        .legal-section ul { margin-left: 1.5rem; color: var(--gray-600); }
        .legal-section li { margin-bottom: 0.5rem; }
        .highlight-box { background: var(--accent); border-left: 4px solid var(--primary); padding: 1.5rem; border-radius: 8px; margin: 1.5rem 0; }
        .footer { background: var(--gray-900); color: var(--white); padding: 4rem 0 0; }
        .footer-content { max-width: 1400px; margin: 0 auto; padding: 0 1.5rem; display: grid; grid-template-columns: 2fr 1fr 1fr 1fr; gap: 3rem; }
        .footer-column a { color: var(--gray-400); text-decoration: none; }
        .footer-bottom { border-top: 1px solid var(--gray-800); margin-top: 3rem; padding: 2rem 1.5rem; max-width: 1400px; margin-left: auto; margin-right: auto; display: flex; justify-content: space-between; }
        @media (max-width: 768px) {
            .page-header h1 { font-size: 2rem; }
            .footer-content { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>
    <header class="header">
        <div class="header-top">
            <div class="header-top-content">
                <span>Windthorststraße 21, 65929 Frankfurt</span>
                <div class="emergency-hotline">NOTFALL: 112</div>
            </div>
        </div>
        <div class="header-main">
            <?php
            $logoUrl = getSetting('logo_url', '');
            if ($logoUrl):
            ?>
                <a href="index.php" class="logo" style="display: flex; align-items: center;">
                    <img src="<?php echo e($logoUrl); ?>" alt="<?php echo e(getSetting('hospital_name', 'Ars Medical Frankfurt')); ?>" style="max-height: 50px; max-width: 200px; width: auto;">
                </a>
            <?php else: ?>
                <a href="index.php" class="logo">
                    <div class="logo-icon">
                        <svg fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                    </div>
                    <div class="logo-text"><h1>Ars Medical</h1></div>
                </a>
            <?php endif; ?>
            <nav class="nav-desktop">
                <a href="index.php">Startseite</a>
                <a href="services.php">Leistungen</a>
                <a href="doctors.php">Ärzte</a>
                <a href="notfall.php">Notfall</a>
                <a href="patienteninfo.php">Patienteninfo</a>
                <a href="krankenkassen.php">Krankenkassen</a>
            </nav>
            <a href="index.php#contact" class="btn">Termin buchen</a>
        </div>
    </header>

    <section class="page-header">
        <h1>Datenschutzerklärung</h1>
        <p>Informationen zur Verarbeitung Ihrer Daten gemäß DSGVO</p>
    </section>

    <nav class="breadcrumb">
        <a href="index.php">Startseite</a> / <span>Datenschutz</span>
    </nav>

    <section class="section">
        <div class="content">
            <div class="highlight-box">
                <p><strong>Datenschutz ist uns wichtig.</strong> Wir nehmen den Schutz Ihrer persönlichen Daten sehr ernst und behandeln Ihre personenbezogenen Daten vertraulich und entsprechend der gesetzlichen Datenschutzvorschriften sowie dieser Datenschutzerklärung.</p>
            </div>

            <div class="legal-section">
                <h2>1. Verantwortlicher</h2>
                <p><strong>Ars Medical Frankfurt GmbH</strong><br>
                Windthorststraße 21<br>
                65929 Frankfurt am Main<br>
                Deutschland</p>
                <p><strong>Datenschutzbeauftragter:</strong><br>
                Max Mustermann<br>
                E-Mail: <a href="mailto:datenschutz@arsmedicafrankfurt.de">datenschutz@arsmedicafrankfurt.de</a><br>
                Telefon: +49 69 1234 5680</p>
            </div>

            <div class="legal-section">
                <h2>2. Erhebung und Speicherung personenbezogener Daten</h2>
                <p>Wir erheben und speichern personenbezogene Daten, wenn Sie:</p>
                <ul>
                    <li>Unsere Website besuchen (Server-Logfiles)</li>
                    <li>Ein Kontaktformular ausfüllen</li>
                    <li>Einen Termin online buchen</li>
                    <li>Uns per E-Mail oder Telefon kontaktieren</li>
                    <li>Patient bei uns sind (medizinische Daten)</li>
                </ul>
            </div>

            <div class="legal-section">
                <h2>3. Verwendungszwecke der Daten</h2>
                <p>Wir verwenden Ihre Daten für folgende Zwecke:</p>
                <ul>
                    <li>Bereitstellung der Website und ihrer Funktionen</li>
                    <li>Beantwortung von Anfragen</li>
                    <li>Terminvereinbarung und -verwaltung</li>
                    <li>Patientenbehandlung und -betreuung</li>
                    <li>Abrechnung mit Krankenkassen</li>
                    <li>Qualitätssicherung und ärztliche Fortbildung</li>
                </ul>
            </div>

            <div class="legal-section">
                <h2>4. Rechtsgrundlagen der Verarbeitung</h2>
                <p>Die Verarbeitung Ihrer Daten erfolgt auf Grundlage von:</p>
                <ul>
                    <li><strong>Art. 6 Abs. 1 lit. a DSGVO:</strong> Einwilligung (z.B. für Marketingzwecke)</li>
                    <li><strong>Art. 6 Abs. 1 lit. b DSGVO:</strong> Vertragserfüllung (Patientenbehandlung)</li>
                    <li><strong>Art. 6 Abs. 1 lit. c DSGVO:</strong> Gesetzliche Verpflichtung (z.B. Aufbewahrungspflichten)</li>
                    <li><strong>Art. 6 Abs. 1 lit. f DSGVO:</strong> Berechtigtes Interesse (z.B. Website-Optimierung)</li>
                </ul>
            </div>

            <div class="legal-section">
                <h2>5. Speicherdauer</h2>
                <p>Wir speichern Ihre Daten nur so lange, wie es für die jeweiligen Zwecke erforderlich ist oder gesetzliche Aufbewahrungspflichten bestehen:</p>
                <ul>
                    <li>Patientenakten: 10 Jahre nach Behandlungsende (§ 630f BGB)</li>
                    <li>Röntgenaufnahmen: 10 Jahre</li>
                    <li>Abrechnungsunterlagen: 10 Jahre (§ 257 HGB)</li>
                    <li>Server-Logfiles: 7 Tage</li>
                </ul>
            </div>

            <div class="legal-section">
                <h2>6. Ihre Rechte</h2>
                <p>Sie haben folgende Rechte bezüglich Ihrer personenbezogenen Daten:</p>
                <ul>
                    <li><strong>Auskunftsrecht (Art. 15 DSGVO):</strong> Information über gespeicherte Daten</li>
                    <li><strong>Berichtigungsrecht (Art. 16 DSGVO):</strong> Korrektur unrichtiger Daten</li>
                    <li><strong>Löschungsrecht (Art. 17 DSGVO):</strong> Löschung unter bestimmten Voraussetzungen</li>
                    <li><strong>Einschränkungsrecht (Art. 18 DSGVO):</strong> Einschränkung der Verarbeitung</li>
                    <li><strong>Datenübertragbarkeit (Art. 20 DSGVO):</strong> Übertragung in maschinenlesbarem Format</li>
                    <li><strong>Widerspruchsrecht (Art. 21 DSGVO):</strong> Widerspruch gegen Verarbeitung</li>
                </ul>
                <p>Zur Ausübung Ihrer Rechte kontaktieren Sie bitte unseren Datenschutzbeauftragten.</p>
            </div>

            <div class="legal-section">
                <h2>7. Cookies und Tracking</h2>
                <p>Unsere Website verwendet Cookies für:</p>
                <ul>
                    <li>Technisch notwendige Cookies (Session, Sicherheit)</li>
                    <li>Analyse-Cookies (mit Ihrer Einwilligung)</li>
                </ul>
                <p>Sie können Cookies in Ihren Browsereinstellungen deaktivieren.</p>
            </div>

            <div class="legal-section">
                <h2>8. Datensicherheit</h2>
                <p>Wir setzen technische und organisatorische Maßnahmen ein, um Ihre Daten zu schützen:</p>
                <ul>
                    <li>SSL-/TLS-Verschlüsselung für Datenübertragung</li>
                    <li>Zugriffskontrollen und Authentifizierung</li>
                    <li>Regelmäßige Sicherheitsupdates</li>
                    <li>Mitarbeiterschulung zum Datenschutz</li>
                </ul>
            </div>

            <div class="legal-section">
                <h2>9. Weitergabe von Daten</h2>
                <p>Eine Weitergabe Ihrer Daten erfolgt nur:</p>
                <ul>
                    <li>An behandelnde Ärzte und medizinisches Fachpersonal</li>
                    <li>An Krankenkassen zur Abrechnung</li>
                    <li>An Labore und diagnostische Einrichtungen</li>
                    <li>Bei gesetzlicher Verpflichtung</li>
                </ul>
            </div>

            <div class="legal-section">
                <h2>10. Beschwerderecht</h2>
                <p>Sie haben das Recht, sich bei einer Datenschutz-Aufsichtsbehörde zu beschweren:</p>
                <p><strong>Hessischer Datenschutzbeauftragter</strong><br>
                Postfach 3163<br>
                65021 Wiesbaden<br>
                Telefon: +49 611 1408-0<br>
                E-Mail: <a href="mailto:poststelle@datenschutz.hessen.de">poststelle@datenschutz.hessen.de</a><br>
                Website: <a href="https://datenschutz.hessen.de" target="_blank" rel="noopener">www.datenschutz.hessen.de</a></p>
            </div>

            <div class="legal-section">
                <h2>11. Aktualisierung</h2>
                <p>Diese Datenschutzerklärung wurde zuletzt aktualisiert am: <strong>25. Februar 2026</strong></p>
                <p>Wir behalten uns vor, diese Erklärung bei Bedarf anzupassen, um sie an geänderte rechtliche Anforderungen oder Änderungen unserer Dienstleistungen anzupassen.</p>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="footer-content">
            <div class="footer-column">
                <h4>Ars Medical Frankfurt</h4>
                <p style="color: var(--gray-400);">Ihr Krankenhaus mit 168 Jahren Tradition.</p>
            </div>
            <div class="footer-column">
                <h4>Informationen</h4>
                <ul style="list-style: none;">
                    <li><a href="notfall.php">Notfall</a></li>
                    <li><a href="patienteninfo.php">Patienteninfo</a></li>
                    <li><a href="krankenkassen.php">Krankenkassen</a></li>
                </ul>
            </div>
            <div class="footer-column">
                <h4>Rechtliches</h4>
                <ul style="list-style: none;">
                    <li><a href="impressum.php">Impressum</a></li>
                    <li><a href="datenschutz.php">Datenschutz</a></li>
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            <p style="color: var(--gray-500);">&copy; 2026 Ars Medical Frankfurt</p>
        </div>
    </footer>
</body>
</html>