<?php
/**
 * Ars Medical Frankfurt - Database Test Script
 * Quick test to check database connection and tables
 */

// Enable error display for debugging
error_reporting(E_ALL);
ini_set('display_errors', '1');

header('Content-Type: text/plain');

echo "=== Database Connection Test ===\n\n";

try {
    require_once __DIR__ . '/../includes/functions.php';
    echo "Functions loaded successfully\n";
} catch (Exception $e) {
    echo "ERROR loading functions: " . $e->getMessage() . "\n";
    exit;
}

try {
    $db = Database::getInstance();
    echo "Database connection established\n";
} catch (Exception $e) {
    echo "ERROR connecting to database: " . $e->getMessage() . "\n";
    exit;
}

// Check tables
echo "\n=== Table Check ===\n\n";

$tables = ['users', 'patients', 'invoices', 'site_settings', 'notifications', 'activity_log', 'login_attempts'];

foreach ($tables as $table) {
    try {
        // Try direct PDO query to get actual error
        $stmt = $db->getConnection()->prepare("SHOW TABLES LIKE ?");
        $stmt->execute([$table]);
        $result = $stmt->fetch();
        if ($result) {
            echo "[OK] Table '$table' exists\n";
        } else {
            echo "[MISSING] Table '$table' does NOT exist\n";
        }
    } catch (PDOException $e) {
        echo "[ERROR] Checking '$table': " . $e->getMessage() . "\n";
    } catch (Exception $e) {
        echo "[ERROR] Checking '$table': " . $e->getMessage() . "\n";
    }
}

echo "\n=== Test Complete ===\n";
