<?php
/**
 * Ars Medical Frankfurt - Logout Handler
 */

if (!defined('SECURE_ACCESS')) {
    define('SECURE_ACCESS', true);
}

require_once __DIR__ . '/../includes/functions.php';

// Log activity before destroying session
if (isLoggedIn()) {
    logActivity('logout', 'users', getCurrentUserId(), 'User logged out');
}

// Clear session data
$_SESSION = [];

// Destroy session cookie
if (isset($_COOKIE[session_name()])) {
    setcookie(session_name(), '', [
        'expires' => time() - 3600,
        'path' => '/',
        'secure' => true,
        'httponly' => true,
        'samesite' => 'Strict'
    ]);
}

// Destroy session
session_destroy();

// Redirect to login page
header('Location: /admin/login.php');
exit;
